<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('report.accounting.header-menu', ['active_header' => 'income-expense-summary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card mt-2">
        <div class="card-body">
            <form action="<?php echo e(route('accounting.income-expense.summary')); ?>" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range" value="<?php echo e(request()->query('date_range')); ?>" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Expense Report</h6>
            <div class="d-flex justify-content-end">
                <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print" onclick="printDiv()"><i class="fas fa-print"></i></a>
            </div>
        </div>
        <hr>
        <div class="row table_content">
            <div class="col-md-12">
                <div class="row p-3">
                    <div class="col-md-4">
                        <div class="card" style="border-left: 4px solid var(--blue);">
                            <div class="card-body">
                                <div class="align-items-center">
                                    <div style="margin: -10px;">
                                        <div class="text-sm font-weight-bold text-uppercase">Total Income : <?php echo e(number_format(round($totalIncome), 0)); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card" style="border-left: 4px solid var(--blue);">
                            <div class="card-body">
                                <div class="align-items-center">
                                    <div style="margin: -10px;">
                                        <div class="text-sm font-weight-bold text-uppercase">Total Expense : <?php echo e(number_format(round($totalExpense), 0)); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card" style="border-left: 4px solid var(--blue);">
                            <div class="card-body">
                                <div class="align-items-center">
                                    <div style="margin: -10px;">
                                        <div class="text-sm font-weight-bold text-uppercase">Total Revenue : <?php echo e(number_format(round($totalIncome - $totalExpense), 0)); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row p-3">
                    <div class="col-md-6">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Total Income</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $incomes['incomes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <td><?php echo e($income->income_date); ?></td>
                                    <td><?php echo e($income->total_amount); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Total Expense</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expenses['expenses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$key); ?></td>
                                    <td><?php echo e($expense->expense_date); ?></td>
                                    <td><?php echo e($expense->total_amount); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('scripts'); ?>
        <script>

        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/report/accounting/income-expense-summary.blade.php ENDPATH**/ ?>