<?php $__env->startSection('content'); ?>

    <div class="tab__item">
        <div class="row">
            <div class="col-xl-12 col-xxl-8 m-auto">
                <div class="card mt-4">
                    <div class="card-body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#student-class-tab" role="tab">Class</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#section-tab" role="tab">Section</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#group-tab" role="tab">Group</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#shift-tab" role="tab">Shift</a>
                        </li>
                    </ul>


                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div id="student-class-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab', 'student-class') === 'student-class' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Class</h6>
                                <button class="btn btn-sm btn-light-blue" data-toggle="modal"
                                        data-target="#StudentClassStoreModal"
                                        data-type="section">Add New
                                </button>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip table-bordered">
                                    <thead class="thead-light">
                                    <tr>
                                        
                                        <th>Class</th>
                                        <th>Secton</th>
                                        <th>Class Teacher</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $studentClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentClass): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($studentClass->class_name); ?></td>

                                                
                                                <td>
                                                    <?php $__currentLoopData = $studentClass->classSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge badge-primary"><?php echo e($classSection?->section?->section_name); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>

                                                
                                                <td>
                                                    <?php $__currentLoopData = $studentClass->classSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="badge badge-primary"><?php echo e($classSection?->classTeacher?->name); ?></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>

                                                <td class="d-flex justify-content-start">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.student-class.edit')): ?>
                                                        <button class="btn btn-sm btn-soft-info mx-1"
                                                            id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#StudentClassEditModal"
                                                            data-section-ids="<?php echo e($studentClass->classSections->pluck('section_id')->implode(',')); ?>"
                                                            data-class-name="<?php echo e($studentClass->class_name); ?>"
                                                            data-id="<?php echo e($studentClass->id); ?>"
                                                        >
                                                            <i class="fas fa-edit"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="section-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab') === 'section' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Section</h6>
                                <div class="m-0 float-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.sections.create')): ?>
                                        <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                                data-toggle="modal" data-target="#SectionStoreModal">Add New
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($section->section_name); ?></td>
                                            <td class="d-flex justify-content-start">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.sections.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#SectionEditModal"
                                                            data-name="<?php echo e($section->section_name); ?>"
                                                            data-id="<?php echo e($section->id); ?>"><i class="fas fa-edit"></i>
                                                    </button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.sections.delete')): ?>
                                                    
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div id="group-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab') === 'group' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Group</h6>
                                <div class="m-0 float-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.groups.create')): ?>
                                        <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                                data-toggle="modal" data-target="#GroupStoreModal">Add
                                            New
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Status</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(!empty($groups)): ?>
                                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e(++$key); ?></td>
                                                <td><?php echo e($group->group_name); ?></td>
                                                <td>
                                                        <span
                                                            class="badge <?php echo e($group->status == 1 ? 'badge-success' : 'badge-warning'); ?>"><?php echo e($group->status == 1 ? 'Active' : 'In-Active'); ?></span>
                                                </td>
                                                <td class="d-flex justify-content-start">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.groups.edit')): ?>
                                                        <button class="btn btn-sm btn-soft-info mr-1"
                                                                id="add-student-btn" data-toggle="modal"
                                                                data-target="#GroupEditModal"
                                                                data-name="<?php echo e($group->group_name); ?>"
                                                                data-status="<?php echo e($group->status); ?>"
                                                                data-id="<?php echo e($group->id); ?>"><i class="fas fa-edit"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.groups.delete')): ?>
                                                        
                                                    <?php endif; ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>


                        <div id="shift-tab"
                             class="tab-pane fade <?php echo e(request()->query('tab') === 'shift' ? 'show active' : ''); ?>">
                            <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                                <h6 class="m-0 table__top__txt">All Shift</h6>
                                <div class="m-0 float-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.shifts.create')): ?>
                                        <button class="btn btn-sm btn-light-blue" data-toggle="modal"
                                                data-target="#ShiftStoreModal"
                                                data-type="shift">Add New
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-strip">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($shift->shift_name); ?></td>
                                            <td><?php echo e(time_format($shift->start_time)); ?></td>
                                            <td><?php echo e(time_format($shift->end_time)); ?></td>
                                            <td class="d-flex justify-content-start">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.shifts.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal" data-target="#ShiftEditModal"
                                                            data-name="<?php echo e($shift->shift_name); ?>"
                                                            data-start="<?php echo e($shift->start_time); ?>"
                                                            data-end="<?php echo e($shift->end_time); ?>"
                                                            data-id="<?php echo e($shift->id); ?>"><i
                                                            class="fas fa-edit"></i></button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.shifts.delete')): ?>
                                                    
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>


                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Section create Modal -->
    <div class="modal fade" id="SectionStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('sections.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel1">Add Section </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="section_name">Section Name <span class="text-danger">*</span></label>
                            <input id="section_name" type="text" class="form-control" name="section_name"
                                   placeholder="Enter Section Name" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="SectionEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('sections.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel2">Edit Section </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="section_name">Section Name <span class="text-danger">*</span></label>
                            <input id="section_name" type="text" class="form-control" name="section_name" required>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Section modal end -->

    <!-- Group create Modal -->
    <div class="modal fade" id="GroupStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('groups.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel3">Add Group </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="group_name">Group Name <span class="text-danger">*</span></label>
                            <input id="group_name" type="text" class="form-control" name="group_name" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Group Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control ">
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="GroupEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('groups.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel4">Edit Group </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="group_name">Group Name <span class="text-danger">*</span></label>
                            <input id="group_name" type="text" class="form-control" name="group_name" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Group Status <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control ">
                                <option value="1">Active</option>
                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Grop modal end -->

    <!-- Department create Modal -->
    <div class="modal fade" id="DepartmentStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('department.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel5">Add Department</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="inputName">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" maxlength="250" id="inputName" name="name"
                                   required placeholder="Enter department"/>
                            <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name') : ''); ?></span>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">

                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="DepartmentEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('department.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel6">Edit Department</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="hidden" id="id" name="id">
                            <input type="text" class="form-control" maxlength="250" id="name" name="name"
                                   required placeholder="Enter department"/>
                            <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name') : ''); ?></span>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Department modal end -->

    <!-- Shift create Modal -->
    <div class="modal fade" id="ShiftStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('shifts.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel7">Add Shift </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="shift_name">Shift Name <span class="text-danger">*</span></label>
                            <input id="shift_name" type="text" class="form-control" name="shift_name" required>
                        </div>
                        <div class="form-group ">
                            <label for="start_time">Start Time <span class="text-danger">*</span></label>
                            <input id="start_time" type="time" class="form-control" name="start_time" required step="60">
                        </div>
                        <div class="form-group">
                            <label for="end_time">End Time <span class="text-danger">*</span></label>
                            <input id="end_time" type="time" class="form-control" name="end_time" required step="60">
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="ShiftEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('shifts.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel8">Edit Shift </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="shift_name">Shift Name <span class="text-danger">*</span></label>
                            <input id="shift_name" type="text" class="form-control" name="shift_name" required>
                        </div>
                        <div class="form-group ">
                            <label for="start_time">Start Time <span class="text-danger">*</span></label>
                            <input id="start_time" type="time" class="form-control" name="start_time" required step="60">
                        </div>
                        <div class="form-group">
                            <label for="end_time">End Time <span class="text-danger">*</span></label>
                            <input id="end_time" type="time" class="form-control" name="end_time" required step="60">
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!--Shift modal end -->

    <!-- student class create Modal -->
    <div class="modal fade" id="StudentClassStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('student_class.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel9">Add Class </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>

                        

                        <div class="form-group">
                            <label for="class_name">Class Name <span class="text-danger">*</span></label>
                            <input id="class_name" type="text"
                                   class="form-control <?php $__errorArgs = ['class_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="class_name"
                                   value="<?php echo e(old('class_name')); ?>" placeholder="Enter class name" required>
                        </div>

                        <div class="form-group">
                            <label>Sections</label>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="custom-control custom-checkbox mb-2">
                                    <input type="checkbox" class="custom-control-input" id="section<?php echo e($section->id); ?>"
                                           name="sections[]" value="<?php echo e($section->id); ?>">
                                    <label class="custom-control-label"
                                           for="section<?php echo e($section->id); ?>"><?php echo e($section->section_name); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="StudentClassEditModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" method="POST" action="<?php echo e(route('student_class.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel10">Edit Class </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="class_name_edit">Class Name <span class="text-danger">*</span></label>
                            <input id="class_name_edit" type="text"
                                   class="form-control <?php $__errorArgs = ['class_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="class_name"
                                   value="<?php echo e(old('class_name')); ?>" placeholder="Enter class name" required>
                        </div>

                        <div class="form-group">
                            <label>Sections</label>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="custom-control custom-checkbox mb-2">
                                    <input type="checkbox" class="custom-control-input" id="section-edit<?php echo e($section->id); ?>"
                                           name="sections[]" value="<?php echo e($section->id); ?>">
                                    <label class="custom-control-label"
                                           for="section-edit<?php echo e($section->id); ?>"><?php echo e($section->section_name); ?></label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- student class modal end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">

        // Save active tab on click
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });

        // Load active tab on page reload
        $(document).ready(function () {
            var activeTab = localStorage.getItem('activeTab');
            if (activeTab) {
                $('a[href="' + activeTab + '"]').tab('show');
            }
        });

        // SectionEditModal
        $('#SectionEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var studentClass = button.data('student-class')
            var id = button.data('id')
            console.log(studentClass)
            var modal = $(this)
            modal.find('#section_name').val(name)
            modal.find("#student_class option[value=" + studentClass + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
        // GroupEditModal
        $('#GroupEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var status = button.data('status')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#group_name').val(name)
            modal.find("#status option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
        // DepartmentEditModal
        $('#DepartmentEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal
            var name = button.data('name')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#name').val(name)
            modal.find('#id').val(id)
        })
        // ShiftEditModal
        $('#ShiftEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var start = button.data('start')
            var end = button.data('end')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#shift_name').val(name)
            modal.find('#start_time').val(start)
            modal.find('#end_time').val(end)
            modal.find('#id').val(id)
        })
        // StudentClassEditModal
        $('#StudentClassEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var className = button.data('class-name')
            var sectionIds = button.data('section-ids')
            console.log(sectionIds);
            var id = button.data('id')
            var modal = $(this)
            modal.find('#class_name_edit').val(className)
            modal.find('#id').val(id)
            // 1. Clear all checkboxes first
            modal.find('input[name="sections[]"]').prop('checked', false);
            if (sectionIds) {
                var ids = sectionIds.toString().split(','); 

                // 3. Loop and check them
                ids.forEach(function (sid) {
                    modal.find('#section-edit' + sid.trim()).prop('checked', true);
                });
            }

        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/academic-setup/index.blade.php ENDPATH**/ ?>