<?php $__env->startSection('content'); ?>
    <style>
        .custom-switch-inline {
            display: inline-block;
            margin-left: 10px; /* add some space between the label and the checkbox */
        }

        .custom-switch-inline .custom-control-label {
            margin-left: 5px; /* add some space between the checkbox and the label */
        }

        .table td, .table th {
            padding: .25rem;
            vertical-align: top;
            border-top: 1px solid #e3e6f0;
        }

        .select2-selection__rendered {
            line-height: 27px !important;
        }

        .data__search .content {
            border-left: 3px solid var(--logo-edu);
            padding-left: 7px;
        }

        .data__search .multiselect-filter {
            display: none;
        }

        .data__search .dropdown-menu.show {
            display: block;
            width: 100%;
            padding-top: 13px;
            border-radius: 0 0 4px 4px !important;
            margin-top: -2px;
        }

        .form-control:disabled, .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #646464;
            font-weight: 300;
            padding-left: 0;
        }

        .fee__sum .form-control:disabled, .fee__sum .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #000;
            font-weight: 700;
            padding-left: 0;
        }

        .fee__sum {
            background: #fffcf9;
            border: 1px solid orange;
            padding: 9px;
        }

        .item__fee__type {
            border-bottom: 1px solid #ddd;
            padding-bottom: .1rem;
            margin-bottom: .1rem;
            display: inline-block;
            font-size: .9rem;
        }

        .fee__sum label {
            margin-bottom: 0;
            color: #222222;
        }

        .fee__sum .fs__l {
            line-height: 1;
            padding: 4px 7px;
            margin-bottom: 10px;
            justify-content: space-between;
            align-items: center;
            background: #40a6dd21;
            border: 1px solid #40a6dd3d;
        }

        /*.data__search .table-bordered td, .data__search .table-bordered th {*/
        /*    border: 1px solid #fce5bf;*/
        /*}*/
    </style>

    <style>
        /*================
        Fee Collection Page
        =====================*/
        .custom-switch-inline {
            display: inline-block;
            margin-left: 10px; /* add some space between the label and the checkbox */
        }

        .custom-switch-inline .custom-control-label {
            margin-left: 5px; /* add some space between the checkbox and the label */
        }

        .table td, .table th {
            padding: .25rem;
            vertical-align: top;
            border-top: 1px solid #e3e6f0;
        }

        .select2-selection__rendered {
            line-height: 27px !important;
        }

        .fee__sum .form-control:disabled, .fee__sum .form-control[readonly] {
            background-color: transparent;
            opacity: 1;
            border: none;
            color: #000;
            font-weight: 700;
            padding-left: 0;
            font-size: 16px;
            text-align: right;
        }

        .fee__sum {
            background: transparent;
            border: 1px solid #d1d5dd;
            padding: 9px;
        }

        .fee__sum label {
            margin-bottom: 0;
            color: #222222;
        }

        .fee__sum .fs__l {
            background: #ecf1f9;
            line-height: 1;
            padding: 4px 7px;
            margin-bottom: 10px;
            justify-content: space-between;
            align-items: center;
        }

        .fee__sum .label__fine {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        /*.data__search .table-bordered td, .data__search .table-bordered th {*/
        /*    border: 1px solid #fce5bf;*/
        /*}*/


        .fee__collection__body .card-body .table .thead-light th {
            font-weight: 500;
            font-size: 1rem;
            padding: .7rem 1.5rem;
            line-height: 1;
        }

        .fee__collection__body .card-body .table .thead-light th:last-child {
            text-align: right !important;
        }

        .fee__collection__body .custom-control-input:checked ~ .custom-control-label::before {
            color: #fff;
            border-color: #00b744;
            background-color: #00b744;
        }

        .fee__collection__body .custom-checkbox .custom-control-label::before {
            border-radius: 0px;
            top: 5px;
        }

        .fee__collection__body .table td, .table th {
            padding: .8rem 1.5rem;
            vertical-align: middle;
            border-top: 1px solid #e3e6f0;
        }

        .fee__collection__body table .tbl__footer {
            background: #25af2c24;
        }

        .fee__collection__body table td:first-child {
            text-align: left !important;
        }

        .fee__collection__body table td:last-child {
            text-align: right !important;
        }

        .fee__collection__body table .tbl__footer td {
            font-weight: bold;
            color: var(--black);
            text-align: center !important;
        }

        .fee__collection__body table .tbl__footer td:last-child {
            text-align: right !important;
        }
    </style>

    <div class="card data__search">
        <div class="card-body card__head">
            <form action="<?php echo e(route('selected-applicant-payment',['id'=>$applicant->id])); ?>" method="GET">
                <div class="row">
                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            <?php
                                $selectedYear = request()->year_id ?? $defaultYear;
                                $selectedMonth = request()->month ?? date('n');
                            ?>
                            <?php echo e(generateDropdown($years, 'name="year_id" class="form-control form-control-sm" required', $selectedYear, 'Year' )); ?>

                        </div>
                    </div>
                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            <?php echo e(generateDropdown($months, 'name="month" class="form-control form-control-sm" id="multiselect"', $selectedMonth, 'Select months...' )); ?>

                        </div>
                    </div>
                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            <select name="discount_type" class="form-control form-control-sm" id="discount_type">
                                <option value="">Discount Type</option>
                                <option value="fixedamount"
                                    <?php echo e(old('discount_type', $discount_type ?? '') == 'fixedamount' ? 'selected' : ''); ?>>
                                    Fixed Amount
                                </option>
                                <option value="percentage"
                                    <?php echo e(old('discount_type', $discount_type ?? '') == 'percentage' ? 'selected' : ''); ?>>
                                    Percentage (%)
                                </option>
                            </select>
                        </div>

                    </div>

                    <div class="col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                        <div class="form-group mb-0">
                            <input type="number" name="discount_amount" min="0" value="<?php echo e(old('discount_amount', $discount_amount ?? '')); ?>" class="form-control">
                        </div>
                    </div>

                    

                    <div class="col-lg-3">
                        <div class="form-group mb-0">
                            <input type="hidden" name="student_class_id" value="<?php echo e($applicant->student_class_id ?? ''); ?>">
                            <button class="btn btn-sm btn-info">Search</button>
                        </div>
                    </div>
                    <?php if(isset($applicant)): ?>
                        <div class="col-md-12">
                            <div class="content mt-3">
                                <div class="title">
                                    Student Info:
                                </div>
                                <div class="body d-flex">
                                    <div class="name mr-3">
                                        <span><b>Name:</b> <?php echo e(($applicant->first_name ?? '') . ' ' . ($applicant->last_name ?? '')); ?></span>
                                    </div>
                                    <div class="class mr-3">
                                        <span><b>Class (Section): </b>
                                            <?php echo e($applicant->studentClass->class_name ?? ''); ?>

                                            <?php if($applicant?->section?->section_name): ?>
                                                (<?php echo e($applicant?->section?->section_name); ?>)
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
    <?php if($errors->any()): ?>
        <div class="alert alert-warning m-3" role="alert">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php if(isset($selectedFeeTypes) && empty($selectedFeeTypes)): ?>
        <div class="text-center">
            <svg viewBox="0 0 112 112" width="112" height="112" class="x14rh7hd x1lliihq x1tzjh5l x1k90msu x2h7rmj x1qfuztq"
                 style="--x-color: var(--primary-icon);">
                <defs>
                    <clipPath id="a">
                        <path fill="#a4a7ab" d="M94.38 98.59H21.51V11.18h44.55l28.32 23.45v63.96z"></path>
                    </clipPath>
                </defs>
                <path fill="#a4a7ab" d="M94.38 98.59H21.51V11.18h44.55l28.32 23.45v63.96z"></path>
                <g clip-path="url(#a)">
                    <path fill="#a4a7ab" d="M94.38 98.59H21.51V11.18h44.55l28.32 23.45v63.96z"></path>
                    <path fill="#87d534" d="M65.94 8.72h32.27v25.95H73a7 7 0 0 1-7-7V8.72h-.06z"></path>
                </g>
                <rect width="57.1" height="3.51" x="29.39" y="47.67" fill="#fff" rx="1.68"></rect>
                <rect width="57.1" height="3.51" x="29.39" y="58.2" fill="#fff" rx="1.68"></rect>
                <rect width="57.1" height="3.51" x="29.39" y="68.73" fill="#fff" rx="1.68"></rect>
            </svg>
            <div class="m-3" role="alert">
                <p class="text-muted">No Fees setup assigned yet for class "<?php echo e($student_details->studentClass->class_name); ?>"- <?php echo e($years[$year_id]); ?></p>
                <a href="<?php echo e(route('class_fees.create')); ?>" target="_blank" class="txt_underline">Setup Now</a>
            </div>
        </div>
    <?php endif; ?>

    <?php if(isset($selectedFeeTypes) && !empty($selectedFeeTypes)): ?>
        <div class="card mt-4 data__search fee__collection__body">
            <div class="card-body">
                <form action="<?php echo e(route('selected-applicant-admitted', $applicant->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-8">
                            <?php if(isset($applicant)): ?>
                                <input type="hidden" name="discount_type" value="<?php echo e($discount_type ?? ''); ?>">
                                <input type="hidden" name="discount" value="<?php echo e($discount_amount ?? ''); ?>">
                                <input type="hidden" name="year_id" value="<?php echo e($year_id ?? ''); ?>">
                                <input type="hidden" name="shift_id" value="<?php echo e($applicant->shift_id); ?>">
                                <input type="hidden" name="student_class_id" value="<?php echo e($applicant->student_class_id); ?>">
                                <input type="hidden" name="section_id" value="<?php echo e($applicant->section_id); ?>">
                                <input type="hidden" name="monthly_total_fees" value="<?php echo e($totalMonthlyFees); ?>">
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="feeTypeTable">
                                        <thead class="thead-light">
                                        <tr>
                                            <th>Months</th>
                                            <th style="min-width: 250px">Fee Type</th>
                                            <th>Total Fees (Tk.)</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php if(!empty($selectedFeeTypes)): ?>
                                            <?php
                                                $feeDetails = [];
                                                $feeTypesAndAmount = [];
                                                foreach ($selectedFeeTypes as $feeType) {
                                                    $feeDetails[] = $feeType->FeeType->title . ' ' . $feeType->amount;
                                                    $feeTypesAndAmount[] = $feeType->FeeType->id . '-' . $feeType->amount;
                                                }
                                                $feeDetails[] = 'Admission Fee ' . number_format($admissionFee, 2);
                                            ?>
                                                <tr class="subject-entry">
                                                    <td><?php echo e(Carbon\Carbon::create()->month($selectedMonth)->format('F') ?? 'N/A'); ?></td>
                                                    <td>
                                                        <?php $__currentLoopData = $selectedFeeTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classFee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                           <?php echo e($classFee->feeType->title ?? 'N/A'); ?> <?php echo e($classFee->amount ?? '0'); ?> <br>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        
                                                        Admission Fee <?php echo e(number_format($admissionFee, 2)); ?>

                                                        
                                                    </td>
                                                    
                                                    <td class="text-center"><?php echo e(number_format($totalAmount, 2) ?? '0.00'); ?></td>
                                                </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-4">
                            <div class="fee__sum">
                                <div class="total__fees fs__l d-flex">
                                    <label>Total Fees:</label>
                                    <div class="value">
                                        <input type="text"
                                               class="form-control form-control-sm"
                                               name="total_amount"
                                               value="<?php echo e($totalAmount ?? '0.00'); ?>" readonly>
                                    </div>
                                </div>
                                <div class="total__dis fs__l d-flex">
                                    <label>Total Discount:</label>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm total_discount"
                                               name="total_discount"
                                               value="<?php echo e($totalDiscount ?? '0.00'); ?>" readonly>
                                    </div>
                                </div>
                                

                                <div class="grand__total fs__l d-flex">
                                    <label>Grand Total:</label>
                                    <div class="value">
                                        <input type="text" class="form-control form-control-sm grand_total"
                                               name="grand_total"
                                               value="<?php echo e($totalDueAmount ?? '0.00'); ?>"
                                               readonly>
                                        <input type="hidden" name="applicant_id" value="<?php echo e($applicant->id ?? ''); ?>">
                                        <input type="hidden" name="selected_month" value="<?php echo e($selectedMonth ?? ''); ?>">
                                        <input type="hidden" name="year_id" value="<?php echo e($year_id ?? ''); ?>">
                                        <input type="hidden" name="fee_details" value='<?php echo json_encode($feeDetails, 15, 512) ?>'>
                                        <input type="hidden" name="fee_types_and_amount" value='<?php echo json_encode($feeTypesAndAmount, 15, 512) ?>'>

                                    </div>
                                </div>
                                <div class="note my-3">
                                    <label class="mb-1">Payment Method:</label>
                                    <?php echo e(generateDropdown($paymentMethods, 'name="payment_method" id="payment_method" class="form-control form-control-sm" required', old('payment_method', Accounting::CASH), '' )); ?>

                                </div>
                                <div class="note">
                                    <label class="mb-1">Note (Optional):</label>
                                    <textarea class="form-control form-control-sm note" name="note" id="" cols="30"
                                              rows="2"
                                              placeholder="Write note or description if needed."></textarea>
                                </div>

                            </div>
                            <div class="flex justify-content-end mt-3">
                                <?php if($applicant->admitted != 1): ?>
                                    <button type="submit" class="btn btn-submit mt-2" name="action" value="collect-print">
                                        Save
                                    </button>
                                <?php else: ?>
                                    
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
document.getElementById('printBtn').addEventListener('click', function () {
    window.print();
});
</script>
    <script>

        


        document.addEventListener('DOMContentLoaded', function () {
            const monthCheckboxes = document.querySelectorAll('.month-checkbox');
            const feeCheckboxes = document.querySelectorAll('.fee-checkbox');
            const totalAmountInput = document.querySelector('.total_amount');
            const grandTotalInput = document.querySelector('.grand_total');

            function updateTotals() {
                let total = 0;

                document.querySelectorAll('.fee-checkbox:checked').forEach(cb => {
                    total += parseFloat(cb.dataset.amount);
                });

                totalAmountInput.value = total.toFixed(2);
                grandTotalInput.value = total.toFixed(2); // Assuming late fine is 0
            }

            monthCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function () {
                    const month = this.dataset.month;

                    document.querySelectorAll(`.fee-checkbox[data-month="${month}"]`).forEach(cb => {
                        cb.checked = this.checked;
                    });

                    updateTotals();
                });
            });

            // Recalculate on manual fee-type checkbox changes too
            feeCheckboxes.forEach(cb => {
                cb.addEventListener('change', updateTotals);
            });

            // Optional: recalculate on page load (if some already checked)
            updateTotals();
        });
    </script>



    <script>
        $(document).ready(function () {
            // Select All checkbox change event
            $('#selectAll').change(function () {
                $('.feeTypeCheckbox').prop('checked', this.checked);
            });

            $('#multiselect').multiselect({
                // Customization Options
                enableFiltering: true,           // Search/Filter option
                filterPlaceholder: 'Search...',  // Filter placeholder text
                maxHeight: 250,                  // Maximum dropdown height
                numberDisplayed: 3,              // Number of selected items to display
                disableIfEmpty: true,            // Disable if no options
                includeSelectAllOption: true,
                // Text Configurations
                nonSelectedText: 'Select Options',
                allSelectedText: 'All Selected',

                // Button Width
                buttonWidth: '100%',

                // Custom Styling
                buttonClass: 'btn btn-light',

                // Event Handlers
                onChange: function (option, checked) {
                    var selectedOptions = $('#multiselect').val();
                }
            });

            const currentMonth = parseInt("<?php echo e(date('m')); ?>");
            const lastPayDay = parseFloat("<?php echo e(get_setting_value(Settings::LATE_FINE_START_DAY)); ?>");
            const currentDay = parseInt("<?php echo e(date('d')); ?>");

            let totalAmount = 0;
            let totalDiscount = 0;
            let grandTotal = 0;
            let lateFine = 0;

            // Function to determine if late fine should apply
            function shouldApplyLateFine() {
                let applyLateFine = false;
                $('.feeTypeCheckbox:checked').each(function () {
                    const month = parseInt($(this).closest('tr').find('.fee-month').val());
                    if (month < currentMonth || (month === currentMonth && lastPayDay < currentDay)) {
                        applyLateFine = true;
                    }
                });
                return applyLateFine;
            }

            // Update totals
            function updateTotals(amountChange, discountChange) {
                totalAmount += amountChange;
                totalDiscount += discountChange;
                grandTotal = (totalAmount + lateFine) - totalDiscount;
                $('.total_amount').val(totalAmount);
                $('.total_discount').val(totalDiscount);
                $('.late_fine').val(lateFine);
                $('.grand_total').val(grandTotal);
            }

            // Individual checkbox change event
            $('.feeTypeCheckbox').change(function () {
                const amount = parseFloat($(this).closest('tr').find('.amountInput').val());
                const discount = parseFloat($(this).closest('tr').find('.discount').val() || 0);

                if (this.checked) {
                    updateTotals(amount, discount);
                } else {
                    updateTotals(-amount, -discount);
                }

                lateFine = shouldApplyLateFine() && $('.customSwitch1').prop('checked') ? lateFineAmount : 0;
                updateTotals(0, 0); // Update grand total with late fine
            });

            $('.customSwitch1').change(function () {
                lateFine = this.checked && shouldApplyLateFine() ? lateFineAmount : 0;
                $('.late_fine').val(lateFine);
                grandTotal = (totalAmount + lateFine) - totalDiscount;
                $('.grand_total').val(grandTotal);
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/admission/online-admission/selected-applicant-payment.blade.php ENDPATH**/ ?>