<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="m-0 table__top__txt">Assign Class Teachers</h6>
            <div class="m-0 float-right">
                <a href="<?php echo e(route('class_teachers.index')); ?>" class="btn btn-sm btn-light-blue">Class Teachers</a>
            </div>
        </div>

        <div class="card-body pt-3">
            <form action="<?php echo e(route('class_teachers.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Sections</label>
                            <?php echo e(generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', '', 'Select shift')); ?>

                        </div>
                        <div class="form-group">
                            <label for="class_name">Class Name <span class="text-danger">*</span></label>
                            <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class" id="student_class" name="student_class_id" required', '', "Select Class")); ?>

                        </div>
                        <div class="form-group">
                            <label>Sections</label>
                            <?php echo e(generateDropdown($sections, 'class="form-control section_id" id="section_id" name="section_id"', '', 'Select Section')); ?>

                        </div>
                        <div class="form-group">
                            <label for="teacher_id">Class Teacher</label>
                            <?php echo e(generateDropdown($teachers, 'class="form-control select2" name="teacher_id" required', old('teacher_id'), 'Select Teacher')); ?>

                        </div>

                        <div class="mt-3 flex justify-content-end">
                            <a href="<?php echo e(route('class_teachers.index')); ?>" type="button" class="btn btn-default mr-3">Discard</a>
                            <button class="btn btn-submit" type="submit" onclick="return confirm('Are you sure you want to save class Teachers')">Submit</button>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "<?php echo e(isset($student_class_id) ? $student_class_id : ''); ?>";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){
            let section_id = "<?php echo e(isset($section_id) ? $section_id : ''); ?>";
            if(student_class_id){
                $.get('<?php echo e(route('sections.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                    let sections = response;

                    let option = '<option value="">--Select Section--</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }

                        // }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/class_teachers/create.blade.php ENDPATH**/ ?>