<?php $__env->startSection('content'); ?>
    <div class="container-fluid class__timetable">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                <div class="page-header mb-4">
                    <div class="page-block mb-0">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">Class Timetable</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php
                        $routinesByDay = $classRoutine?->routineDetails?->groupBy('day');
                    ?>

                    <div class="row">
                        <?php $__currentLoopData = ['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 col-md-6 col-lg-4 mb-4">
                                <div class="card h-100 day-card">
                                    <div class="card-header bg-light">
                                        <h4 class="mb-0"><?php echo e($day); ?></h4>
                                    </div>
                                    <div class="card-body p-0">
                                        <?php if(!isset($routinesByDay[$day]) || $routinesByDay[$day]->isEmpty()): ?>
                                            <div class="p-4 text-center text-muted">
                                                No classes scheduled for this day.
                                            </div>
                                        <?php else: ?>
                                            <div class="list-group list-group-flush sub__info">
                                                <?php $__currentLoopData = $routinesByDay[$day]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routineDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="list-group-item">
                                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                                            <h5 class="mb-0 sub__name"><?php echo e($routineDetail->subject->subject_name ?? 'N/A'); ?></h5>
                                                            <span class="badge bg-primary" style="padding: 10px 12px;font-size: 13px;font-weight: 400;letter-spacing: 1px;">Room - <?php echo e($routineDetail->class_room_id ?? 'N/A'); ?></span>
                                                        </div>
                                                        <div class="small text-muted mb-2">
                                                            <i class="fas fa-user-tie me-1"></i>
                                                            <span class="sub__teacher"><?php echo e($routineDetail->teacher->name ?? 'N/A'); ?></span>
                                                        </div>
                                                        <div class="small sub__time">
                                                            <i class="fas fa-clock me-1"></i>
                                                            <?php echo e($routineDetail->start_time); ?>

                                                            - <?php echo e($routineDetail->end_time); ?>

                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .day-card {
            transition: transform 0.2s;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .day-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }

        @media (max-width: 768px) {
            .day-card {
                margin-bottom: 1rem;
            }
        }
    </style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/class-routine.blade.php ENDPATH**/ ?>