<?php $__env->startSection('content'); ?>

<div class="tab__item">
    <div class="row">
        <div class="col-md-10 col-lg-8 m-auto">
            <div class="card mt-4">
                <!-- Nav tabs -->
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#building-tab" role="tab">Building</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#room-tab" role="tab">Room</a>
                    </li>
                </ul>

                <!-- Tab panes -->
                <div class="tab-content">
                    <div id="building-tab" class="tab-pane fade show active">
                        <!-- Building content -->
                        <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 table__top__txt">All Building</h6>
                            <div class="m-0 float-right">
                                <button class="btn btn-sm btn-light-blue"
                                    data-toggle="modal" data-target="#BuildingStoreModal">Add New
                                </button>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-strip">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Branch</th>
                                    <th>Building</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                    $sn = 0;
                                ?>
                                <?php $__currentLoopData = $buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$sn); ?></td>
                                        <td><?php echo e($building->branch->branch_name); ?></td>
                                        <td><?php echo e($building->building_name); ?></td>
                                        <td class="d-flex justify-content-start">
                                            <button class="btn btn-sm btn-soft-info mr-1"
                                                    data-toggle="modal"
                                                    data-target="#BuildingEditModal"
                                                    data-branch="<?php echo e($building->branch->id); ?>"
                                                    data-building="<?php echo e($building->building_name); ?>"
                                                    data-id="<?php echo e($building->id); ?>"><i class="fas fa-edit"></i>
                                            </button>
                                            <form action="<?php echo e(route('buildings.destroy', $building->id)); ?>" method="POST"
                                                  class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this branch?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div id="room-tab" class="tab-pane fade">
                        <!-- Room content -->
                        <div class="pb-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 table__top__txt">All Room</h6>
                            <div class="m-0 float-right">
                                <button class="btn btn-sm btn-light-blue"
                                    data-toggle="modal" data-target="#RoomStoreModal">Add New
                                </button>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-strip">
                            <thead class="thead-light">
                                    <tr>
                                        <th>ID</th>
                                        <th>Room No</th>
                                        <th>Building</th>
                                        <th>Total Seat</th>
                                        <th class="action__col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $class_rooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($room->id); ?></td>
                                        <td><?php echo e($room->room_no); ?></td>
                                        <td><?php echo e($room->building->building_name); ?></td>
                                        <td><?php echo e($room->total_seat); ?></td>
                                        <td class="d-flex justify-content-start">
                                            <button class="btn btn-sm btn-soft-info mr-1"
                                                    data-toggle="modal"
                                                    data-target="#RoomEditModal"
                                                    data-room="<?php echo e($room->room_no); ?>"
                                                    data-building="<?php echo e($room->building->id); ?>"
                                                    data-seat="<?php echo e($room->total_seat); ?>"
                                                    data-id="<?php echo e($room->id); ?>"><i class="fas fa-edit"></i>
                                            </button>
                                            <a class="btn btn-sm btn-soft-danger" onclick="return confirm('Are you sure you want to delete this')" href="<?php echo e(route('class_rooms.destroy',['class_room'=>$room->id])); ?>"><i class="fas fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                        </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

    <!-- Building create Modal -->
    <div class="modal fade" id="BuildingStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form method="POST" action="<?php echo e(route('buildings.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Building</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="building_name">Building Name <span class="text-danger">*</span></label>
                            <input id="building_name" type="text"
                                class="form-control <?php $__errorArgs = ['building_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="building_name"
                                autocomplete="building_name" autofocus required>
                        </div>
                        <div class="form-group">
                            <label for="provost">Select Branch <span class="text-danger">*</span></label>
                            <?php echo e(generateDropdown($branches, 'class="form-control select2" name="branch_id" required')); ?>

                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
 
    <div class="modal fade" id="BuildingEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('buildings.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Building</h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="building_name">Building Name <span class="text-danger">*</span></label>
                            <input id="building_name" type="text"
                                class="form-control <?php $__errorArgs = ['building_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="building_name"
                                autocomplete="building_name" autofocus required>
                        </div>
                        <div class="form-group">
                            <label for="branch_name">Select Branch <span class="text-danger">*</span></label>
                            <?php echo e(generateDropdown($branches, 'class="form-control select2 branch_name" id="branch_name" name="branch_id" required')); ?>

                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Building modal end -->
<!-- Room  Modal -->
<div class="modal fade" id="RoomStoreModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('class_rooms.store')); ?>">
            <?php echo csrf_field(); ?>
            <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Add Class Room</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <p class="statusMsg"></p>
                    <div class="form-group">
                        <label for="room_no">Room No <span class="text-danger">*</span></label>
                        <input id="room_no" type="text" class="form-control" name="room_no" placeholder="Enter room no" required>
                    </div>
                    <div class="form-group">
                        <label for="building_id">Building <span class="text-danger">*</span></label>
                        <?php echo e(generateDropdown($buildings_arr, 'class="form-control select2" name="building_id" required')); ?>

                    </div>
                    <div class="form-group">
                        <label for="total_seat">Total Seat <span class="text-danger">*</span></label>
                        <input id="total_seat" type="number" class="form-control" name="total_seat" min="0" placeholder="Enter total seat" required>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="RoomEditModal" role="dialog">
    <div class="modal-dialog modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form role="form" id='myForm' method="POST" action="<?php echo e(route('class_rooms.update')); ?>">
            <?php echo csrf_field(); ?>
            <!-- Modal Header -->
                <div class="modal-header">
                    <div class="float-start">
                        <h4 class="modal-title" id="myModalLabel">Edit Class Room</h4>
                    </div>
                    <div class="float-end d-none">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                            <span class="sr-only">Close</span>
                        </button>
                    </div>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                    <p class="statusMsg"></p>
                    <input type="hidden" id="id" name="id">
                    <div class="form-group">
                        <label for="room_no">Room No <span class="text-danger">*</span></label>
                        <input id="room_no" type="text" class="form-control" name="room_no" placeholder="Enter room no" required>
                    </div>
                    <div class="form-group">
                        <label for="building_id">Building <span class="text-danger">*</span></label>
                        <?php echo e(generateDropdown($buildings_arr, 'class="form-control select2" id="building_id" name="building_id" required')); ?>

                    </div>
                    <div class="form-group">
                        <label for="total_seat">Total Seat <span class="text-danger">*</span></label>
                        <input id="total_seat" type="number" class="form-control" name="total_seat" min="0" placeholder="Enter total seat" required>
                    </div>
                </div>
                <!-- Modal Footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Room modal end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">

    // Save active tab to localStorage
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        localStorage.setItem('activeTab', $(e.target).attr('href'));
    });

    // Load last active tab from localStorage
    $(document).ready(function () {
        var activeTab = localStorage.getItem('activeTab');
        if (activeTab) {
            $('a[data-toggle="tab"][href="' + activeTab + '"]').tab('show');
        }
    });



    $('#BuildingEditModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget)
        var branch_name = button.data('branch')
        var building_name = button.data('building')
        var id = button.data('id')
        var modal = $(this)
        modal.find('#building_name').val(building_name)
        modal.find("#branch_name").val(branch_name).trigger('change');
        modal.find('#id').val(id)
    })

    $('#RoomEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var room_no = button.data('room')
            var building = button.data('building')
            var seat = button.data('seat')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#room_no').val(room_no)
            modal.find('#total_seat').val(seat)
            modal.find("#building_id").val(building).trigger('change');
            modal.find('#id').val(id)
        })
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/building-setup/index.blade.php ENDPATH**/ ?>