<?php $__env->startSection('content'); ?>
<style>
/*    ///new*/
    .id-card {
        height: 450px;
        margin: 10px;
        padding: 10px;
        background-color: transparent;
        border-radius: 10px;
        box-shadow: 0 0 10px rgb(0 0 0 / 15%);
    }
    .id-card-header {
/*        background-color: #f0f0f0;*/
        padding: 10px;
/*        border-bottom: 1px solid #ccc;*/
        background: #10af95
        text-align: center;
    }
    .id-card-header img{
        width: 100%;
        height: auto !important;
        padding: .25rem !important;
        background: #10af95
    }
    .id-card-body {
        padding: 10px;
    }
    .id-card-body .student-image {
        text-align: center;
        margin-bottom: 5px;
    }
    .id-card-body .student-image img{
        width: 80px;
        height: 80px;
        border: 2px solid #ffc94ea6;
        border-radius: 0 !important;
        padding: 10px;
        margin-bottom:10px;
    }
    .id-card-body .student-info {
        padding: 0;
    }
    
    .id-card-text {
        font-size: 14px;
    }
    .id-card-title {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 0px;
    }
    .id-card-footer {
        padding: 10px;
        border-top: 6px solid #ffc94ea6;
    }
    

</style>
<div class="card">
    <div class="card-body card__head">
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link <?php echo e(request()->query('tab', 'search') === 'search' ? 'active' : ''); ?>" data-toggle="tab" href="#search-tab">Search By ID</a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e(request()->query('tab') === 'filter' ? 'active' : ''); ?>" data-toggle="tab" href="#filter-tab">Search by Class</a>
            </li>
        </ul>
        <!-- Tab panes -->
        <div class="tab-content">
            <div id="search-tab" class="tab-pane <?php echo e(request()->query('tab', 'search') === 'search' ? 'show active' : ''); ?>"><br>
                <form method="GET" action="<?php echo e(route('student.id-card.index')); ?>" class="row">
                    <input type="hidden" name="tab" value="search">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <?php $__env->startComponent('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => request()->student_id_no ?? '',
                            'required' => '',
                        ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            <div id="filter-tab" class="tab-pane fade <?php echo e(request()->query('tab') === 'filter' ? 'show active' : ''); ?>"><br>
                <form method="GET" action="<?php echo e(route('student.id-card.index')); ?>" class="row">
                    <input type="hidden" name="tab" value="filter">
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Class")); ?>

                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <?php echo e(generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section")); ?>

                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <?php echo e(generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift")); ?>

                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <?php echo e(generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group")); ?>

                    </div>
                    <div class="form-group col-lg-2 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php if($students): ?> 
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
        <h6 class="m-0 table__top__txt">Student List
            <?php if($students): ?>
                (Total Students : <?php echo e($students ? $students->count() : 'N/A'); ?>)
            <?php endif; ?></h6>
        <div class="m-0 float-right">
            <form method="GET" action="<?php echo e(route('studentIdCardDownload')); ?>" class="row" target="_blank">
            <div class="d-none">
                <div class="form-group mb-0">
                    <?php $__env->startComponent('components.search_student', [
                        'student_name' => $student_name ?? '',
                        'student_id_no' => request()->student_id_no ?? '',
                        'required' => '',
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </div>
            </div>
            <div class="d-none">
                <?php echo e(generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift")); ?>

            </div>
            <div class="d-none">
                <?php echo e(generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group")); ?>

            </div>
            <div class="d-none">
                <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Class")); ?>

            </div>

            <div class="d-none">
                <?php echo e(generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section")); ?>

            </div>

            <?php if(!empty($students)): ?>
            <button type="submit" class="btn btn-sm btn-primary">Download</button>
            <?php endif; ?>
        </form>

        </div>
    </div>

    <div class="card-body">
        
        <div class="row">
            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $student_image = $student->profile_image ? $student->profile_image : 'uploads/student/graduated_student.png';
                ?>
                <div class="col-md-4">
                    <div class="id-card">
                        
                        <div class="id-card-header">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <?php
                                        $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : '/default/default.png';
                                    ?>
                                    <img src="<?php echo e(asset($logo_path)); ?>" style="background: #10af95;height:auto;width:70px;" class=" p-1">
                                    
                                </div>
                                
                            </div>
                        </div>
                        <div class="id-card-body">
                            <div class="student-image">
                                <img src="<?php echo e(asset($student_image)); ?>" alt ="Student Image" class="img-fluid rounded-circle" style="width: 80px; height: 80px;">
                            </div>
                            <div class="student-info">
                                <h5 class="id-card-title"><?php echo e("$student->first_name $student->last_name"); ?></h5>
                                <p class="id-card-text">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <strong>Student ID:</strong> <?php echo e($student->student_id_no ?? ""); ?>

                                        </div>
                                        <div class="col-md-6">
                                            <strong>Roll:</strong> <?php echo e($student->class_roll ?? ""); ?>

                                        </div>
                                        <div class="col-md-6">
                                            <strong>Class:</strong> <?php echo e($student->studentClass->class_name ?? ""); ?>

                                        </div>
                                        <div class="col-md-6">
                                            <strong>Shift:</strong> <?php echo e($student->shift->shift_name ?? ""); ?>

                                        </div>
                                        <div class="col-md-6">
                                            <strong>Section:</strong> <?php echo e($student->section->section_name ?? ""); ?>

                                        </div>
                                        <div class="col-md-6">
                                            <strong>DOB:</strong> <?php echo e($student->date_of_birth ?? ""); ?>

                                        </div>
                                        
                                    </div>
                                </p>
                            </div>
                            <img src="<?php echo e(asset('/signature/principal.jpg')); ?>" alt="" style="width: 100px; height: 30px;">
                            <p class="id-card-text">Principal's Signature</p>
                        </div>
                        <div class="id-card-footer">
                           
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
 
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/students/id-card/index.blade.php ENDPATH**/ ?>