<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('report.accounting.header-menu', ['active_header' => 'income-expense-headwise-report'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card mt-2">
        <div class="card-body">
            <form action="<?php echo e(route('accounting.income-expense.headwise-report')); ?>" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range"
                                    value="<?php echo e(request()->query('date_range')); ?>" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Income Expense Headwise Report</h6>
            <div class="d-flex justify-content-end">
                <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print"
                    onclick="printDiv('landscape')"><i class="fas fa-print"></i></a>
            </div>
        </div>
        <div class="row table_content">
            <div class="col-md-6">
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Income Head</th>
                            <th>Total Income</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($income->accounting_head_name); ?></td>
                                <td><?php echo e($income->total_amount); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Expense Head</th>
                            <th>Total Expense</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($expense->accounting_head_name); ?></td>
                                <td><?php echo e($expense->total_amount); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/report/accounting/income-expense-headwise-report.blade.php ENDPATH**/ ?>