<?php $__env->startSection('styles'); ?>
<style type="text/css">
    .attendance_status{
        width: 34px !important;
        height: 34px !important;
        font-weight: bold !important;
        padding-top: 5px !important;
    }
    .table .thead-light th:first-child, .card .table td:first-child{
        min-width: 25px !important;
    }
    .card .table td, .card .table th{
        padding-right: 1px !important;
        padding-left: 1px !important;
        text-align: center;
        min-width: 25px;
        /* height: auto; */
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body card__head">
        <form method="POST" action="<?php echo e(route('student_attendance.attendance_report')); ?>" class="row">
            <?php echo csrf_field(); ?>
            <div class="col-md-6">
                <div class="row">
                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                        <?php echo e(generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Select Shift")); ?>

                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class_id student_class" id="student_class" name="student_class_id"', $student_class_id, "Select Class")); ?>

                    </div>
                    <div class="form-group col-lg-4 col-md-6 col-sm-6">
                        <?php echo e(generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section')); ?>

                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <?php if (isset($component)) { $__componentOriginal24102f1ac62c394be69e2bc4df251128 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal24102f1ac62c394be69e2bc4df251128 = $attributes; } ?>
<?php $component = App\View\Components\GroupSelector::resolve(['name' => 'group_id','label' => '','labelText' => 'Group','col' => 'form-group col-lg-3 col-md-6 col-sm-6','required' => (int) request()->input('student_class') >= 11,'selected' => old('group_id') ?? request()->input('group_id')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('group-selector'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\GroupSelector::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['student_class_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute((int) request()->input('student_class'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $attributes = $__attributesOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__attributesOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $component = $__componentOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__componentOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
                    
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <select name="year" class="form-control year">
                            <?php $__currentLoopData = $academicYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a_year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($a_year->year == $year): ?>
                                    <option value="<?php echo e($a_year->year); ?>" selected><?php echo e($a_year->year); ?></option>
                                <?php else: ?>
                                    <option value="<?php echo e($a_year->year); ?>"><?php echo e($a_year->year); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">   
                        <?php echo e(generateDropdown(config('months'), 'class="form-control month" id="month" name="month"', $month, "Select Month")); ?>

                    </div>
                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        <button type="submit" class="btn btn-info">Search</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php if(isset($students)): ?>
    <div class="card mt-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Roll</th>
                                    <th>Name</th>
                                    <?php for($i=1; $i<=$totalDays; $i++): ?>
                                        <th><?php echo e($i); ?></th>
                                    <?php endfor; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$key); ?></td>
                                        <td><?php echo e($student->class_roll); ?></td>
                                        <td><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></td>
                                        <?php
                                            $currentDate = \Carbon\Carbon::parse($from_date);
                                        ?>
                                        <?php for($day = 1; $day <= $totalDays; $day++): ?>
                                            <td>
                                                <?php
                                                    $attendance = $student->attendances->firstWhere('punch_date', $currentDate->toDateString());
                                                ?>
                                                <?php if($attendance): ?>
                                                    <?php if($attendance->day_status=='A'): ?>
                                                    <span class="d-inline-block rounded-circle bg-danger text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;"><?php echo e($attendance->day_status); ?></span>
                                                    <?php else: ?>
                                                    <span class="d-inline-block rounded-circle bg-success text-white text-center" style="width: 26px; height: 26px; line-height: 26px; font-weight: bold;"><?php echo e($attendance->day_status); ?></span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>
                                                <?php
                                                    $currentDate = $currentDate->addDays(1);
                                                ?>
                                            </td>
                                        <?php endfor; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        const shift_id = "<?php echo e($shift_id); ?>";
        const studentAttendance = (event,student_id) => {
            event.preventDefault();
            if(student_id){
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${student_id}`;
                $.post("<?php echo e(route('student_attendance.store')); ?>", {
                    _token: csrfToken,
                    student_id: student_id,
                    shift_id: shift_id
                }, function(response) {
                    console.log(response)
                    if (response.success) {
                        const icon = response.success ? '<i style="font-size: 1.5rem;color: green;" class="fas fa-check-circle"></i>' : '<i style="font-size: 1.5rem;color: red;" class="fas fa-exclamation-circle"></i>';
                        $(`#icon-${student_id}`).html(icon);
                        $(buttonId).prop('disabled', true);
                    }
                });
            }
        }
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });
        let student_class_id = "<?php echo e(isset($student_class_id) ? $student_class_id : ''); ?>";
        if(student_class_id!=''){
            getSection(student_class_id);
        }
        function getSection(student_class_id){
            let section_id = "<?php echo e(isset($section_id) ? $section_id : ''); ?>";
            if(student_class_id){
                $.get('<?php echo e(route('sections.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">Select Section</option>';
                    for(let i=0;i<sections.length;i++){
                        // if(sections[i].student_class_id == student_class_id){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                        // }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/student_attendance/report.blade.php ENDPATH**/ ?>