<?php $__env->startSection('content'); ?>



    <div class="row">
        <div class="col-xl-12 col-xxl-8 m-auto">
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 table__top__txt">Branch List</h6>
                    <div class="m-0 float-right">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.branches.create')): ?>
                            <button class="btn btn-sm btn-light-blue" id="add-student-btn"
                                    data-toggle="modal" data-target="#dataStoreModal">Add New
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Address</th>
                                    <th>Contact Info</th>
                                    <th>Status</th>
                                    <th class="action__col">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if($branches->isNotEmpty()): ?>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($branch->id); ?></td>
                                            <td><?php echo e($branch->branch_name); ?></td>
                                            <td><?php echo e($branch->address); ?></td>
                                            <td><?php echo e($branch->contact_info); ?></td>
                                            <td><?php echo getStatus($branch->status); ?></td>
                                            <td class="">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.branches.edit')): ?>
                                                    <button class="btn btn-sm btn-soft-info mr-1" id="add-student-btn"
                                                            data-toggle="modal"
                                                            data-target="#dataEditModal"
                                                            data-name="<?php echo e($branch->branch_name); ?>"
                                                            data-address="<?php echo e($branch->address); ?>"
                                                            data-contact="<?php echo e($branch->contact_info); ?>"
                                                            data-status="<?php echo e($branch->status); ?>"
                                                            data-id="<?php echo e($branch->id); ?>"><i class="fas fa-edit"></i>
                                                    </button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.branches.delete')): ?>
                                                    <form action="<?php echo e(route('branches.destroy', $branch->id)); ?>"
                                                          method="POST"
                                                          class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-soft-danger btn-sm"
                                                                onclick="return confirm('Are you sure you want to delete this branch?')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No data available in table</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- create Modal -->
    <div class="modal fade" id="dataStoreModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('branches.store')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Add Branch </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <div class="form-group">
                            <label for="branch_name">Branch Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="branch_name" name="branch_name"
                                   placeholder="Enter Branch Name" required>
                        </div>
                        <div class="form-group">
                            <label for="address">Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="address" name="address"
                                   placeholder="Enter branch address" required>
                        </div>
                        <div class="form-group">
                            <label for="contact_info">Contact Info <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="contact_info" name="contact_info"
                                   placeholder="Enter contact info" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Status <span class="text-danger">*</span></label>
                            <select type="text" class="form-control" id="status" name="status" required>
                                <option value='1'>Active</option>
                                <option value='0'>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- modal end -->

    <!--edit Modal -->
    <div class="modal fade" id="dataEditModal" role="dialog">
        <div class="modal-dialog modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form role="form" id='myForm' method="POST" action="<?php echo e(route('branches.update')); ?>">
                <?php echo csrf_field(); ?>
                <!-- Modal Header -->
                    <div class="modal-header">
                        <div class="float-start">
                            <h4 class="modal-title" id="myModalLabel">Edit Branch </h4>
                        </div>
                        <div class="float-end d-none">
                            <button type="button" class="close" data-dismiss="modal">
                                <span aria-hidden="true">&times;</span>
                                <span class="sr-only">Close</span>
                            </button>
                        </div>
                    </div>
                    <!-- Modal Body -->
                    <div class="modal-body">
                        <p class="statusMsg"></p>
                        <input type="hidden" id="id" name="id">
                        <div class="form-group">
                            <label for="branch_name">Branch Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="branch_name" name="branch_name"
                                   placeholder="Enter Branch Name" required>
                        </div>
                        <div class="form-group">
                            <label for="address">Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="address" name="address"
                                   placeholder="Enter branch address" required>
                        </div>
                        <div class="form-group">
                            <label for="contact_info">Contact Info <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="contact_info" name="contact_info"
                                   placeholder="Enter contact info" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Status <span class="text-danger">*</span></label>
                            <select type="text" class="form-control" id="status" name="status" required>
                                <option value='1'>Active</option>
                                <option value='0'>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <!-- Modal Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-submit submitBtn">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <!-- modal end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#dataEditModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var name = button.data('name')
            var address = button.data('address')
            var contact = button.data('contact')
            var status = button.data('status')
            var id = button.data('id')
            var modal = $(this)
            modal.find('#branch_name').val(name)
            modal.find('#address').val(address)
            modal.find('#contact_info').val(contact)
            modal.find("#status option[value=" + status + "]").prop("selected", true);
            modal.find('#id').val(id)
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/branch/index.blade.php ENDPATH**/ ?>