<?php $__env->startSection('content'); ?>
    <style type="text/css">
        #profileImgField5 #profileImgInput5,
        #profileImgField4 #profileImgInput4,
        #profileImgField3 #profileImgInput3,
        #profileImgField2 #profileImgInput2 {
            visibility: hidden;
            display: none;
        }

        #profileImgField5,
        #profileImgField4,
        #profileImgField3,
        #profileImgField2 {
            position: relative;
            background: #fff;
            padding: 13px;
            border-radius: 3px;
            box-shadow: 0px 0px 4px #e3e3e3;
            width: 100%;
            height: 150px;
        }

        #profileImgField5 img,
        #profileImgField4 img,
        #profileImgField3 img,
        #profileImgField2 img {
            max-width: 300px;
            max-height: 80px;
            overflow: hidden;
            cursor: pointer;
        }

        #profileImgField5 i,
        #profileImgField4 i,
        #profileImgField3 i,
        #profileImgField2 i {
            position: absolute;
            color: #3abaf4;
            bottom: 6px;
            right: 6px;
            font-size: 49px;
            z-index: 15;
            opacity: .5;
            cursor: pointer;
        }
    </style>
    <div class="card std__form">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <div class="card-body">
            <form action="<?php echo e(route('setting.update')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="py-2 px-0 mb-3 text-white form__head">
                    General Settings
                </div>
                <div class="p-2 form__body">
                    <div class="col-md-12">
                        <div class="row">
                            <?php
                                $branch_id = auth()->user()->branch_id;
                                $school_name = get_setting(Settings::SCHOOL_NAME , $branch_id);
                                $school_name_value = get_setting_value(Settings::SCHOOL_NAME); 
                            ?>
                            <?php if(!empty($school_name)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($school_name->key); ?>">School Name</label>
                                    <input type="text" class="form-control" id="<?php echo e($school_name->key); ?>"
                                        name="<?php echo e($school_name->key); ?>" value="<?php echo e($school_name_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $school_short_name = get_setting(Settings::SCHOOL_SHORT_NAME , $branch_id);
                                $school_short_value = get_setting_value(Settings::SCHOOL_SHORT_NAME);
                            ?>
                            <?php if(!empty($school_short_name)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($school_short_name->key); ?>">School Short Name</label>
                                    <input type="text" class="form-control" id="<?php echo e($school_short_name->key); ?>"
                                        name="<?php echo e($school_short_name->key); ?>" value="<?php echo e($school_short_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $app_name = get_setting(Settings::APP_NAME , $branch_id);
                                $app_name_value = get_setting_value(Settings::APP_NAME);
                            ?>
                            <?php if(!empty($app_name)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($app_name->key); ?>">Application Name</label>
                                    <input type="text" class="form-control" id="<?php echo e($app_name->key); ?>"
                                        name="<?php echo e($app_name->key); ?>" value="<?php echo e($app_name_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $app_footer = get_setting(Settings::APP_FOOTER , $branch_id);
                                $app_footer_value = get_setting_value(Settings::APP_FOOTER);
                            ?>
                            <?php if(!empty($app_footer)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($app_footer->key); ?>">Application Footer</label>
                                    <input type="text" class="form-control" id="<?php echo e($app_footer->key); ?>"
                                        name="<?php echo e($app_footer->key); ?>" value="<?php echo e($app_footer_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $domain = get_setting(Settings::APP_DOMAIN , $branch_id);
                                $domain_value = get_setting_value(Settings::APP_DOMAIN);
                            ?>
                            <?php if(!empty($domain)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($domain->key); ?>">Domain</label>
                                    <input type="text" class="form-control" id="<?php echo e($domain->key); ?>"
                                        name="<?php echo e($domain->key); ?>" value="<?php echo e($domain_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $email = get_setting(Settings::SCHOOL_EMAIL , $branch_id);
                                $email_value = get_setting_value(Settings::SCHOOL_EMAIL);
                            ?>
                            <?php if(!empty($email)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($email->key); ?>">School Email</label>
                                    <input type="text" class="form-control" id="<?php echo e($email->key); ?>"
                                        name="<?php echo e($email->key); ?>" value="<?php echo e($email_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $school_phone = get_setting(Settings::SCHOOL_PHONE , $branch_id);
                                $school_phone_value = get_setting_value(Settings::SCHOOL_PHONE);
                            ?>
                            <?php if(!empty($school_phone)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($school_phone->key); ?>">School Phone</label>
                                    <input type="text" class="form-control" id="<?php echo e($school_phone->key); ?>"
                                        name="<?php echo e($school_phone->key); ?>" value="<?php echo e($school_phone_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $school_code = get_setting(Settings::SCHOOL_CODE , $branch_id);
                                $school_code_value = get_setting_value(Settings::SCHOOL_CODE);
                            ?>
                            <?php if(!empty($school_code)): ?>
                                <div class="form-group col-md-4">
                                    <label for="<?php echo e($school_code->key); ?>">School Code</label>
                                    <input type="text" class="form-control" id="<?php echo e($school_code->key); ?>"
                                        name="<?php echo e($school_code->key); ?>" value="<?php echo e($school_code_value); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="form-group col-md-3 mt-3"></div>


                            <?php
                                $school_logo = get_setting(Settings::SCHOOL_LOGO , $branch_id);
                                $school_logo_value = get_setting_value(Settings::SCHOOL_LOGO);
                            ?>
                            <?php if(!empty($school_logo)): ?>
                                <div class="form-group col-md-3 mt-3">
                                    <div id="profileImgField2">
                                        <label class="d-block">School Logo</label>
                                        <label for="profileImgInput2">
                                            <img class="profileImgShow2"
                                                src="<?php echo e($school_logo_value ? asset($school_logo_value) : asset('default/default.png')); ?>">
                                            <i class="fas fa-cloud-upload-alt"></i>
                                        </label>
                                        <input class="form-control profile-img-input2" id="profileImgInput2"
                                            name="<?php echo e($school_logo->key); ?>" type="file">
                                        <div id="signatureError" class="text-danger"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php
                                $favicon = get_setting(Settings::FAVICON , $branch_id);
                                $favicon_value = get_setting_value(Settings::FAVICON);
                            ?>
                            <?php if(!empty($favicon)): ?>
                                <div class="form-group col-md-3 mt-3">
                                    <div id="profileImgField3">
                                        <label class="d-block">Favicon</label>
                                        <label for="profileImgInput3">
                                            <img class="profileImgShow3"
                                                src="<?php echo e($favicon_value ? asset($favicon_value) : asset('default/default.png')); ?>">
                                            <i class="fas fa-cloud-upload-alt"></i>
                                        </label>
                                        <input class="form-control profile-img-input3" id="profileImgInput3"
                                            name="<?php echo e($favicon->key); ?>" type="file">
                                        <div id="signatureError" class="text-danger"></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php
                                $export_logo = get_setting(Settings::EXPORT_LOGO , $branch_id);
                                $export_logo_value = get_setting_value(Settings::EXPORT_LOGO);
                            ?>
                            <?php if(!empty($export_logo)): ?>
                                <div class="form-group col-md-3 mt-3">
                                    <div id="profileImgField4">
                                        <label class="d-block">Export Logo</label>
                                        <label for="profileImgInput4">
                                            <img class="profileImgShow4"
                                                src="<?php echo e($export_logo_value ? asset($export_logo_value) : asset('default/default.png')); ?>">
                                            <i class="fas fa-cloud-upload-alt"></i>
                                        </label>
                                        <input class="form-control profile-img-input4" id="profileImgInput4"
                                            name="<?php echo e($export_logo->key); ?>" type="file">
                                        <div id="signatureError" class="text-danger"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php
                                $principal_signature = get_setting(Settings::PRINCIPAL_SIGNATURE , $branch_id);
                                $principal_signature_value = get_setting_value(Settings::PRINCIPAL_SIGNATURE);
                            ?>
                            <?php if(!empty($principal_signature)): ?>
                                <div class="form-group col-md-3 mt-3">
                                    <div id="profileImgField5">
                                        <label class="d-block">Principal Signature</label>
                                        <label for="profileImgInput5">
                                            <img class="profileImgShow5"
                                                src="<?php echo e($principal_signature_value ? asset($principal_signature_value) : asset('default/default.png')); ?>">
                                            <i class="fas fa-cloud-upload-alt"></i>
                                        </label>
                                        <input class="form-control profile-img-input5" id="profileImgInput5"
                                            name="<?php echo e($principal_signature->key); ?>" type="file">
                                        <div id="signatureError" class="text-danger"></div>
                                    </div>
                                </div>
                            <?php endif; ?>


                        </div>
                    </div>
                </div>
                <!-- row -->

                <div class="py-2 px-0 mb-3 text-white form__head">
                    Late Fine Setting
                </div>
                <div class="p-2 form__body">
                    <div class="col-md-12">
                        <div class="row">
                            <?php
                                $late_fine_ststus = get_setting(Settings::LATE_FINE_STATUS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::LATE_FINE_STATUS)) && get_setting_value(Settings::LATE_FINE_STATUS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($late_fine_ststus)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($late_fine_ststus->key); ?>">Late Fine Status</label><br>
                                    <input type="hidden" name="<?php echo e($late_fine_ststus->key); ?>" value="0">
                                    <label class="switch">
                                        <input id="<?php echo e($late_fine_ststus->key); ?>"
                                            class="<?php echo e($late_fine_ststus->key); ?>"
                                            data-id="<?php echo e($late_fine_ststus->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($late_fine_ststus->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>


                            <?php
                                $late_fine_start_day = get_setting(Settings::LATE_FINE_START_DAY , $branch_id);
                                $late_fine_start_day_value = get_setting_value(Settings::LATE_FINE_START_DAY);
                            ?>
                            <?php if(!empty($late_fine_start_day)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($late_fine_start_day->key); ?>">Late Fine Start Day</label>
                                    <input type="number" min="0" max="31" class="form-control" id="<?php echo e($late_fine_start_day->key); ?>"
                                        name="<?php echo e($late_fine_start_day->key); ?>" value="<?php echo e($late_fine_start_day_value); ?>">
                                </div>
                            <?php endif; ?>

                            <?php
                                $late_fine_amount = get_setting(Settings::LATE_FINE_AMOUNT , $branch_id);
                                $late_fine_amount_value = get_setting_value(Settings::LATE_FINE_AMOUNT);
                            ?>
                            <?php if(!empty($late_fine_amount)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($late_fine_amount->key); ?>">Late Fine Amount</label>
                                    <input type="number" min="0" max="1000" class="form-control" id="<?php echo e($late_fine_amount->key); ?>"
                                        name="<?php echo e($late_fine_amount->key); ?>" value="<?php echo e($late_fine_amount_value); ?>">
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>


                <div class="py-2 px-0 mb-3 text-white form__head">
                    SMS Setting
                </div>
                <div class="p-2 form__body">
                    <div class="col-md-12">
                        <div class="row">

                            <?php
                                $in_time_sms = get_setting(Settings::IN_TIME_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::IN_TIME_SMS)) && get_setting_value(Settings::IN_TIME_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($in_time_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($in_time_sms->key); ?>">In Time SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($in_time_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($in_time_sms->key); ?>"
                                            class="<?php echo e($in_time_sms->key); ?>"
                                            data-id="<?php echo e($in_time_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($in_time_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>

                            <?php
                                $out_time_sms = get_setting(Settings::OUT_TIME_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::OUT_TIME_SMS)) && get_setting_value(Settings::OUT_TIME_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($out_time_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($out_time_sms->key); ?>">Out Time SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($out_time_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($out_time_sms->key); ?>"
                                            class="<?php echo e($out_time_sms->key); ?>"
                                            data-id="<?php echo e($out_time_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($out_time_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>


                            <?php
                                $billing_sms = get_setting(Settings::BILLING_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::BILLING_SMS)) && get_setting_value(Settings::BILLING_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($billing_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($billing_sms->key); ?>">Billing SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($billing_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($billing_sms->key); ?>"
                                            class="<?php echo e($billing_sms->key); ?>"
                                            data-id="<?php echo e($billing_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($billing_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>

                            <?php
                                $billing_sms_date = get_setting(Settings::BILLING_SMS_DATE , $branch_id);
                                $billing_sms_date_value = get_setting_value(Settings::BILLING_SMS_DATE , $branch_id);
                            ?>
                            <?php if(!empty($billing_sms_date)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($billing_sms_date->key); ?>">Billing SMS Day</label>
                                    <input type="number" min="0" max="31" class="form-control" id="<?php echo e($billing_sms_date->key); ?>"
                                        name="<?php echo e($billing_sms_date->key); ?>" value="<?php echo e($billing_sms_date_value); ?>">
                                </div>
                            <?php endif; ?>


                            <?php
                                $billing_due_sms = get_setting(Settings::BILLING_DUE_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::BILLING_DUE_SMS)) && get_setting_value(Settings::BILLING_DUE_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($billing_due_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($billing_due_sms->key); ?>">Billing Due SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($billing_due_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($billing_due_sms->key); ?>"
                                            class="<?php echo e($billing_due_sms->key); ?>"
                                            data-id="<?php echo e($billing_due_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($billing_due_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>

                            <?php
                                $billing_due_sms_date = get_setting(Settings::BILLING_DUE_SMS_DATE , $branch_id);
                                $billing_due_sms_date_value = get_setting_value(Settings::BILLING_DUE_SMS_DATE , $branch_id);
                            ?>
                            <?php if(!empty($billing_due_sms_date)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($billing_due_sms_date->key); ?>">Billing Due SMS Day</label>
                                    <input type="number" min="0" max="31" class="form-control" id="<?php echo e($billing_due_sms_date->key); ?>"
                                        name="<?php echo e($billing_due_sms_date->key); ?>" value="<?php echo e($billing_due_sms_date_value); ?>">
                                </div>
                            <?php endif; ?>


                            <?php
                                $payment_success_sms = get_setting(Settings::PAYMENT_SUCCESS_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::PAYMENT_SUCCESS_SMS)) && get_setting_value(Settings::PAYMENT_SUCCESS_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($payment_success_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($payment_success_sms->key); ?>">Payment Success SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($payment_success_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($payment_success_sms->key); ?>"
                                            class="<?php echo e($payment_success_sms->key); ?>"
                                            data-id="<?php echo e($payment_success_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($payment_success_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>


                            <?php
                                $birthday_sms = get_setting(Settings::BIRTHDAY_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::BIRTHDAY_SMS)) && get_setting_value(Settings::BIRTHDAY_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($birthday_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($birthday_sms->key); ?>">Birthday SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($birthday_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($birthday_sms->key); ?>"
                                            class="<?php echo e($birthday_sms->key); ?>"
                                            data-id="<?php echo e($birthday_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($birthday_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>


                            <?php
                                $student_create_sms = get_setting(Settings::STUDENT_CREATE_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::STUDENT_CREATE_SMS)) && get_setting_value(Settings::STUDENT_CREATE_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($student_create_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($student_create_sms->key); ?>">Student Create SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($student_create_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($student_create_sms->key); ?>"
                                            class="<?php echo e($student_create_sms->key); ?>"
                                            data-id="<?php echo e($student_create_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($student_create_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>


                            <?php
                                $teacher_create_sms = get_setting(Settings::TEACHER_CREATE_SMS , $branch_id);
                                $isChecked = !empty(get_setting_value(Settings::TEACHER_CREATE_SMS)) && get_setting_value(Settings::TEACHER_CREATE_SMS) == 1 ? 'checked' : '';
                            ?>

                            <?php if(!empty($teacher_create_sms)): ?>
                                <div class="form-group col-md-3">
                                    <label for="<?php echo e($teacher_create_sms->key); ?>">Teacher Create SMS</label><br>

                                    
                                    <input type="hidden" name="<?php echo e($teacher_create_sms->key); ?>" value="0">

                                    <label class="switch">
                                        <input id="<?php echo e($teacher_create_sms->key); ?>"
                                            class="<?php echo e($teacher_create_sms->key); ?>"
                                            data-id="<?php echo e($teacher_create_sms->key); ?>"
                                            type="checkbox"
                                            name="<?php echo e($teacher_create_sms->key); ?>"
                                            value="1"
                                            <?php echo e($isChecked); ?>>
                                        <span class="slider round"></span>
                                    </label>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>


                <div class="py-2 px-0 mb-3 text-white form__head">
                    Student Management Setting
                </div>
                <div class="p-2 form__body">
                    <div class="col-md-12">
                        <div class="row">
                            <?php
                                $student_id_year = get_setting('student_id_year' , $branch_id);
                                $idYerTypes = ['current' => 'Current', 'next' => 'Next'];
                                $dropdownName = $student_id_year->key;
                                $dropdownValue = $student_id_year->value;
                                $dropdownAttributes = 'class=form-control name=' . $dropdownName;
                            ?>
                            <div class="form-group col-md-4">
                                <label for="<?php echo e($dropdownName); ?>">Student ID Year</label>
                                <?php echo generateDropdown($idYerTypes, $dropdownAttributes, $dropdownValue, ''); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3 flex justify-content-end">
                    <button type="submit" id="submitBtn" class="btn btn-submit">Submit</button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('.profile-img-input2').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow2').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
            $('.profile-img-input3').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow3').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })

            $('.profile-img-input4').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow4').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
            $('.profile-img-input5').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow5').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/setting/index.blade.php ENDPATH**/ ?>