<?php $__env->startSection('content'); ?>
    <style>
        .image-uploader {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative; /* Add position relative */
        }

        .image-uploader__label {
            display: flex;
            flex-direction: column;
            align-items: center;
            cursor: pointer;
            position: relative; /* Add position relative */
        }

        .image-uploader__icon-overlay {
            position: absolute;
            top: 50%; /* Align vertically centered */
            left: 50%; /* Align horizontally centered */
            transform: translate(-50%, -50%); /* Center the icon */
            width: 100%;
            height: calc(100%); /* Height equal to parent minus icon height */
            background-color: rgba(0, 0, 0, 0.2); /* Transparent black background */
            border-radius: 50%; /* Rounded border */
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0.3;
        }

        .image-uploader__icon-overlay i {
            color: #ffffff; /* Icon color */
            font-size: 24px; /* Icon size */
        }

        /* Your existing styles */
        .image-uploader__preview {
            overflow: hidden;
        }

        .image-uploader__input {
            display: none;
        }

    </style>

    <div class="card std__form">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
            <h6 class="mx-0 table__top__txt">Add New Student</h6>
            <div class="m-0 float-right">
                <a class="btn btn-sm btn-light-blue" href="<?php echo e(route('student_info.index')); ?>">View All</a>
            </div>
        </div>

        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('student_info.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="py-2 mb-0 form__head">
                    Personal information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="student_id_no">
                                            Student ID
                                            <i class="fas fa-info-circle text-info"
                                               data-container="body"
                                               data-toggle="popover"
                                               data-placement="right"
                                               data-html="true"
                                               data-content="Student ID is automatically generated based on the 'Student Id Year' settings. You can change it from <a href='<?php echo e(route('setting.index')); ?>' target='_blank'><strong>Settings</strong></a> by looking 'Student Id Year'">
                                            </i>
                                        </label>
                                        <input type="text" class="form-control" name="student_id_no" id="student_id_no"
                                               value="<?php echo e($student_id_no); ?>" readonly required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="first_name">First name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="first_name" id="first_name"
                                               value="<?php echo e(old('first_name')); ?>" placeholder="Enter First Name" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="last_name">Last name </label>
                                        <input type="text" class="form-control" name="last_name"
                                               value="<?php echo e(old('last_name')); ?>" placeholder="Enter Last name" required>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="gender">Gender <span class="text-danger">*</span> </label>
                                        <?php echo e(generateDropdown($genderOptions, 'class="form-control" name="gender" required', old('gender'), 'Select Gender')); ?>

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="blood_group">Blood group </label>
                                        <?php echo e(generateDropdown($bloodGroupOptions, 'class="form-control" name="blood_group"', old('blood_group'), 'Select Option')); ?>

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="religion">Religion <span class="text-danger">*</span> </label>
                                        <?php echo e(generateDropdown($religionOptions, 'class="form-control" name="religion" required', 'Islam')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="image-uploader">
                                <label for="image">Profile Image </label>
                                <label for="imageFile" class="image-uploader__label">
                                    <!-- Icon overlay with transparent background -->
                                    <div class="image-uploader__icon-overlay">
                                        <i class="fas fa-cloud-upload-alt"></i>
                                    </div>
                                    <!-- Preview image -->
                                    <img src="<?php echo e(asset('assets/img/boy.png')); ?>" alt="Preview image"
                                         class="image-uploader__preview-image img-thumbnail rounded-circle p-1"
                                         style="width: 140px; height: 140px;">
                                    <!-- File input -->
                                    <input type="file" name="profile_image" class="image-uploader__input" id="imageFile"
                                           accept="image/*">
                                </label>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="date_of_birth">Date of birth <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control date360" name="date_of_birth"
                                       value="<?php echo e(old('date_of_birth')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="birth_certi_no">Birth certificate no </label>
                                <input type="number" class="form-control" name="birth_certi_no"
                                       value="<?php echo e(old('birth_certi_no')); ?>" placeholder="Enter Birth Certificate No">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="mobile_no"><b>Mobile number (for SMS)</b> <span class="text-danger">*</span>
                                </label>
                                <input type="tel" class="form-control" name="mobile_no" value="<?php echo e(old('mobile_no')); ?>"
                                       placeholder="Enter Mobile Number" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="email">Email </label>
                                <input type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>"
                                       placeholder="Enter Email">
                            </div>
                        </div>
                    </div>
                </div>


                <div class="py-2 mb-0 form__head">
                    Academic information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="branch_id">Branch <span class="text-danger">*</span> </label>
                                <?php echo e(generateDropdown($branches, 'class="form-control branch_id" id="branch_id" name="branch_id" required disabled', old('branch_id') ?? $defaultBranch)); ?>

                                <input type="hidden" name="branch_id" value="<?php echo e(old('branch_id') ?? $defaultBranch); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="shift_id">Shift <span class="text-danger">*</span> </label>
                                <?php echo e(generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" required', old('shift_id'), 'Select Option')); ?>

                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="student_class_id">Class <span class="text-danger">*</span> </label>
                                <?php echo e(generateDropdown($studentClasses, 'class="form-control select2 student_class" id="student_class" name="student_class_id" required ', old('student_class_id'), 'Select Option')); ?>

                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="section_id">Section </label>
                                <?php echo e(generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id" ', old('section_id'), 'Select Option')); ?>

                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="group_id">Group </label>
                                <?php echo e(generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', old('group_id'), 'Select Option')); ?>

                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="admission_roll">Admission roll </label>
                                <input type="text" class="form-control" name="admission_roll"
                                       value="<?php echo e(old('admission_roll')); ?>" placeholder="Enter Admission Roll">
                            </div>
                        </div>

                        
                    </div>

                    

                    <div class="row hsc-subjects">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Main/Compulsory Subjects</label>
                                <div class="controls">
                                    <?php if(!empty($compulsory_subjects)): ?>
                                        <?php $__currentLoopData = $compulsory_subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$compulsorySubject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <fieldset>
                                                <input type="checkbox" id="checkbox_<?php echo e($key); ?>" value="<?php echo e($compulsorySubject->subject_id ?? ''); ?>" name="<?php echo e($compulsorySubject->subject->subject_name ?? ''); ?>" checked="" disabled="">
                                                <label for="checkbox_<?php echo e($key); ?>"><?php echo e($compulsorySubject->subject->subject_name ?? ''); ?></label>
                                            </fieldset>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Group Compulsory Subjects</label>
                                <?php if(!empty($subjects)): ?>
                                    <select name="elective_subjects[]" multiple class="form-control select2" >
                                        <option value="">Select Option</option>
                                        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($subject->subject_id); ?>"><?php echo e($subject->subject->subject_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Additional/4th Subjects</label>

                                <div class="controls" id="optional-section">
                                    <?php if(!empty($subjects)): ?>
                                    <select name="optional_subject" class="form-control select2" >
                                        <option value="">Select Option</option>
                                        <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($subject->subject_id); ?>"><?php echo e($subject->subject->subject_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="py-2 mb-0 form__head">
                    Parent information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="father_name">Father's name <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control" name="father_name"
                                       value="<?php echo e(old('father_name')); ?>" placeholder="Enter Father Name" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="father_occupation">Father's occupation </label>
                                <?php echo e(generateDropdown($occupations, 'class="form-control select2 father_occupation" id="father_occupation" name="father_occupation"', old('father_occupation'), 'Select Option')); ?>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="father_mobile">Father mobile </label>
                                <input type="tel" class="form-control" name="father_mobile"
                                       value="<?php echo e(old('father_mobile')); ?>" placeholder="Enter Father Mobile">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="mother_name">Mother name </label>
                                <input type="text" class="form-control" name="mother_name"
                                       value="<?php echo e(old('mother_name')); ?>" placeholder="Enter Mother Name">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="mother_occupation">Mother occupation </label>
                                <?php echo e(generateDropdown($occupations, 'class="form-control select2" name="mother_occupation"', old('mother_occupation'), 'Select Option')); ?>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="mother_mobile">Mother mobile </label>
                                <input type="tel" class="form-control" name="mother_mobile"
                                       value="<?php echo e(old('mother_mobile')); ?>" placeholder="Enter Mother Mobile">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="py-2 mb-0 form__head">
                    Address
                </div>
                <div class="form__body">
                    <div class="row">
                        
                        <label class="ml-2" for="present_address">Present address</label>
                        <div class="row col-md-12 mt-2">
                            <?php if (isset($component)) { $__componentOriginaled3462c3fe352bdde24ef8fe3b389577 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577 = $attributes; } ?>
<?php $component = App\View\Components\LocationDropdown::resolve(['selectedDistrict' => old('present_district_id'),'selectedUpazila' => old('present_upazila_id'),'containerClass' => '','groupClass' => 'form-group col-md-3','labelClass' => 'form-label','selectClass' => 'form-control select2','prefix' => 'present'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('location-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LocationDropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $attributes = $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $component = $__componentOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <textarea class="form-control" name="present_address" id="present_address"
                                              placeholder="Enter Present Address"><?php echo e(old('present_address')); ?></textarea>
                                </div>
                            </div>
                        </div>
                        

                        
                        <label class="ml-2 mt-4" for="permanent_address">Permanent address</label>
                        <div class="mx-2 mt-4">
                            (<input class="mx-2" type="checkbox" id="copyAddress"/>
                            <label for="copyAddress"> Same as present address</label>)
                        </div>

                        <div class="row col-md-12 mt-2">
                            <?php if (isset($component)) { $__componentOriginaled3462c3fe352bdde24ef8fe3b389577 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577 = $attributes; } ?>
<?php $component = App\View\Components\LocationDropdown::resolve(['selectedDistrict' => old('permanent_district_id'),'selectedUpazila' => old('permanent_upazila_id'),'selectedUnion' => old('permanent_union_id'),'containerClass' => '','groupClass' => 'form-group col-md-3','labelClass' => 'form-label','selectClass' => 'form-control select2','prefix' => 'permanent'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('location-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LocationDropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $attributes = $__attributesOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__attributesOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577)): ?>
<?php $component = $__componentOriginaled3462c3fe352bdde24ef8fe3b389577; ?>
<?php unset($__componentOriginaled3462c3fe352bdde24ef8fe3b389577); ?>
<?php endif; ?>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <textarea class="form-control" name="permanent_address" id="permanent_address"
                                              placeholder="Enter Permanent Address"><?php echo e(old('permanent_address')); ?></textarea>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>


                <div class="py-2 mb-0 form__head">
                    Hostel information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="hostel">Hostel </label>
                                <?php echo e(generateDropdown($hostels, 'class="form-control hostel" id="hostel" name="hostel"', old('hostel'), 'Select Option')); ?>

                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="hostel">Floor </label>
                                <?php echo e(generateDropdown([], 'class="form-control select2 hostel_floor_id" id="hostel_floor_id" name="hostel_floor_id"', old('hostel_floor_id'), 'Select Option')); ?>

                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="hostel">Room </label>
                                <?php echo e(generateDropdown([], 'class="form-control select2 room_number" id="room_number" name="room_number"', old('room_number'), 'Select Option')); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="py-2 mb-0 form__head">
                    Transport information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="code">Routes</label>
                                <?php echo e(generateDropdown($transport_routes, 'class="form-control select2 route_id" id="route_id" name="route_id"', '', "Select Option")); ?>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="code">Stoppage</label>
                                <?php echo e(generateDropdown([], 'class="form-control select2 stoppage_id" id="stoppage_id" name="stoppage_id"', '', "Select Option")); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="py-2 mb-0 form__head">
                    Sibling information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-4">
                            <div id="sibling-container">
                                <div class="sibling-entry mb-2 d-flex align-items-center">
                                    <div class="form-group flex-grow-1">
                                        <label for="student-search">Sibling</label>
                                        <input type="text" id="student-search"
                                               class="form-control form-control student-search"
                                               placeholder="Search by Student ID">
                                        <input type="hidden" class="student-search-value" name="student_id_no"
                                               value="<?php echo e($student_id_no ?? ''); ?>">
                                    </div>
                                    <button type="button" class="btn btn-info ml-2 mt-3 add-sibling">Add</button>
                                </div>
                            </div>
                            <div id="siblings-list">
                                <!-- List of siblings will be added here dynamically -->
                            </div>
                        </div>
                    </div>
                </div>


                <div class="py-2 mb-0 form__head">
                    guardian information
                </div>
                <div class="form__body">
                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="guardian_name">Guardian name</label>
                                <input type="text" class="form-control" name="guardian_name"
                                       value="<?php echo e(old('guardian_name')); ?>" placeholder="Enter Gurdian Name">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="guardian_occupation">Guardian occupation </label>
                                <?php echo e(generateDropdown($occupations, 'class="form-control select2" name="guardian_occupation"', old('guardian_occupation'), 'Select Option')); ?>

                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="guardian_mobile">Guardian mobile </label>
                                <input type="tel" class="form-control" name="guardian_mobile"
                                       value="<?php echo e(old('guardian_mobile')); ?>" placeholder="Enter Gurdian Mobile">
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="guardian_relationship">Relation with guardian </label>
                                <?php echo e(generateDropdown($guardian_relations, 'class="form-control select2" name="guardian_relationship"', old('guardian_relationship'), 'Select Option')); ?>

                            </div>
                        </div>
                        <div class="col-md-4">
                            <label for="guardian_address">Guardian address </label>
                            <input type="text" class="form-control" name="guardian_address"
                                   value="<?php echo e(old('guardian_address')); ?>" placeholder="Enter Guardian Address">
                        </div>
                    </div>
                </div>
                <div class="mt-3 flex justify-content-end">
                    <a href="<?php echo e(route('student_info.index')); ?>" type="button" class="btn btn-default mr-3">Discard</a>
                    <button class="btn btn-submit">Submit</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        const input = document.querySelector('.image-uploader__input');
        const previewImage = document.querySelector('.image-uploader__preview-image');

        input.addEventListener('change', () => {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = (event) => {
                previewImage.src = event.target.result;
            };

            reader.readAsDataURL(file);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<script>
    $(document).ready(function () {

        const $studentClass = $('.student_class');

        $studentClass.on('change', function () {
            const student_class_id = $(this).val();
            getSubjects(student_class_id);
        });

        function toggleHscSubjects() {
            const selectedClassId = parseInt($('#student_class').val());

            // Assuming class 11 has ID = 11 and class 12 has ID = 12
            if (selectedClassId === 11 || selectedClassId === 12) {
                $('.hsc-subjects').show();
            } else {
                $('.hsc-subjects').hide();
            }
        }

        // Initial check on page load
        toggleHscSubjects();

        // When the class dropdown changes
        $('#student_class').on('change', function () {
            toggleHscSubjects();
        });


        function getSubjects(student_class_id) {
            let subject_id = "<?php echo e(isset($subject_id) ? addslashes($subject_id) : ''); ?>";
            if (student_class_id) {
                $.get('<?php echo e(route('subjects.list_by_class')); ?>', {student_class_id: student_class_id})
                    .done(function (response) {
                        let option = '<option value="">Subject</option>';
                        response.forEach(function (item) {
                            if (item.student_class_id == student_class_id) {
                                const selected = subject_id == item.subject_id ? ' selected' : '';
                                option += `<option value="${item.subject_id}"${selected}>${item.subject.subject_name}</option>`;
                            }
                        });
                        $subjectSelect.empty().append(option);
                    })
                    .fail(function (jqXHR, textStatus) {
                        console.error('Subjects load failed:', textStatus);
                    });
            }
        }


    });
</script>



    <script>
        $('.student_class').on('change', function () {

            let _this = $(this);
            let student_class_id = _this.val();
            if (student_class_id) {
                $.get('<?php echo e(route('sections.list_by_class')); ?>', {student_class_id: student_class_id}, function (response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Select Option</option>';
                    for (let i = 0; i < sections.length; i++) {

                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name + '</option>';
                        }
                    }
                    $('select.section_id').empty().append(option);
                });
            }
        });

        $('.route_id').on('change', function () {
            let route_id = $(this).val();
            let stoppage_id = '';
            getStoppage(route_id, stoppage_id);
        });

        function getStoppage(route_id, stoppage_id) {

            if (route_id) {
                $.get('<?php echo e(route('stoppage-list-by-route')); ?>', {route_id: route_id}, function (response) {
                    let stoppages = response;

                    let option = '<option value="">Select Option</option>';
                    for (let i = 0; i < stoppages.length; i++) {

                        if (stoppage_id == stoppages[i].id) {
                            option += '<option value=' + stoppages[i].id + ' selected>' + stoppages[i].name + ' -> ( Tk. ' + stoppages[i].monthly_cost + ')</option>';
                        } else {
                            option += '<option value=' + stoppages[i].id + ' >' + stoppages[i].name + ' -> ( Tk. ' + stoppages[i].monthly_cost + ')</option>';
                        }

                    }
                    $('select.stoppage_id').empty().append(option);
                });
            }
        }

        $('.hostel').on('change', function () {
            let hostel_id = $(this).val();
            if (hostel_id) {
                $.get('<?php echo e(route('hostel.floors')); ?>', {hostel_id: hostel_id}, function (response) {
                    let hostel_floors = response;

                    let option = '<option value="">Select Option</option>';
                    for (let i = 0; i < hostel_floors.length; i++) {

                        option += '<option value=' + hostel_floors[i].id + ' >' + hostel_floors[i].name + '</option>';
                    }
                    $('#hostel_floor_id').empty().append(option);

                });
            }
        });

        $('#hostel_floor_id').on('change', function () {
            let hostel_floor_id = $(this).val();
            if (hostel_floor_id) {
                $.get('<?php echo e(route('hostel-room-by-floor')); ?>', {hostel_floor_id: hostel_floor_id}, function (response) {
                    let hostel_rooms = response;

                    let option = '<option value="">Select Option</option>';
                    for (let i = 0; i < hostel_rooms.length; i++) {

                        const disabled = hostel_rooms[i].empty_beds === 0 ? 'disabled' : '';
                        option += `<option value="${hostel_rooms[i].id}" ${disabled}>
                                        ${hostel_rooms[i].room_name} => ${hostel_rooms[i].room_type.name}
                                        => (Tk.${Math.floor(hostel_rooms[i].room_type.cost_per_bed)})
                                        => ${hostel_rooms[i].no_of_bed}/${hostel_rooms[i].empty_beds}
                                    </option>`;
                    }

                    $('#room_number').empty().append(option);

                });
            }
        });

        $(".student-search").autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: "<?php echo e(route('students.search')); ?>",
                    data: {
                        query: request.term
                    },
                    success: function (data) {
                        response($.map(data, function (student) {
                            if (/^0/.test(request.term)) { // Check if mobile number starts with 0
                                return {
                                    label: `${student.first_name} ${student.last_name} (${student.guardian_mobile})`,
                                    value: student.student_id_no
                                };
                            } else { // Otherwise, assume it's an ID starting with 1-9
                                return {
                                    label: `${student.first_name} ${student.last_name} (${student.student_id_no})`,
                                    value: student.student_id_no
                                };
                            }
                        }));
                    }
                });
            },
            minLength: 3, // Trigger autocomplete after 3 characters
            select: function (event, ui) {
                // Set the selected sibling name and ID to the input
                $(this).val(ui.item.label); // Set the label (full name with ID/Mobile)
                $(this).siblings('.student-search-value').val(ui.item.value); // Optionally, store student ID in hidden field
                return false;
            },
            focus: function (event, ui) {
                $(this).val(ui.item.label); // Optionally, show full label when focused
                return false;
            }
        });

        // Handle the "Add" button click to add a sibling entry to the list below
        $(document).on('click', '.add-sibling', function () {
            var $parent = $(this).closest('.sibling-entry'); // Get the current sibling entry
            var siblingName = $parent.find('.student-search').val(); // Get the full name (label) from input field
            var studentId = $parent.find('.student-search-value').val(); // Get the student ID from the hidden input
            console.log(siblingName + '' + studentId);
            // Check if the input is not empty (a sibling has been selected)
            if (siblingName && studentId) {
                // Append the sibling data as a list item in the #siblings-list
                $('#siblings-list').append(`
                    <div class="sibling-item mb-1 p-1 bg-light d-flex justify-content-between align-items-center">
                        <span>${siblingName}</span>
                        <input type="hidden" name="sibling_id_no[]" value="${studentId}">
                        <button type="button" class="btn btn-danger btn-sm remove-sibling"><i class="fas fa-minus-circle"></i></button>
                    </div>
                `);

                // Clear the search input for the next sibling
                $parent.find('.student-search').val('');
                $parent.find('.student-search-value').val('');
            } else {
                alert('Please select a sibling before adding.');
            }
        });

        // Handle the "Remove" button click to remove a sibling from the list
        $(document).on('click', '.remove-sibling', function () {
            $(this).closest('li').remove();
        });
        $("#student-search").on('input', function () {
            if ($(this).val() === '') {
                $('.student-search-value').val('');
            }
        });

        const today = new Date();
        $('.date360').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true,
        }).datepicker('setDate', today);

        $('#copyAddress').on('change', function () {
            if ($(this).is(':checked')) {
                // Copy division value and trigger change event
                const divisionId = $('#present_division_id').val();
                $('#permanent_division_id').val(divisionId).trigger('change');

                // Wait for districts to load before copying district
                setTimeout(() => {
                    const districtId = $('#present_district_id').val();
                    $('#permanent_district_id').val(districtId).trigger('change');

                    // Wait for upazilas to load before copying upazila
                    setTimeout(() => {
                        const upazilaId = $('#present_upazila_id').val();
                        $('#permanent_upazila_id').val(upazilaId).trigger('change');

                        // Wait for unions to load before copying union
                        setTimeout(() => {
                            const unionId = $('#present_union_id').val();
                            $('#permanent_union_id').val(unionId);

                            // Copy textarea content
                            const address = $('#present_address').val();
                            $('#permanent_address').val(address);
                        }, 500);
                    }, 500);
                }, 500);
            }
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/students/student_infos/create.blade.php ENDPATH**/ ?>