<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10 col-lg-8 m-auto">
        <div class="card mt-4" id="print-layout">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Class Teacher List</h6>
                <div class="m-0 float-right">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.assign-class-teacher.edit')): ?>
                    <a href="<?php echo e(route('class_teachers.create')); ?>" class="btn btn-sm btn-light-blue">Create</a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table table-strip">
                            <thead class="thead-light">
                                <tr>
                                    <th>Class</th>
                                    <th>Shift</th>
                                    <th>Section</th>
                                    <th>Class Teacher</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $classTeachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classTeacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($classTeacher->studentClass?->class_name ?? 'N/A'); ?></td>
                                        <td><?php echo e($classTeacher->shift?->shift_name ?? "N/A"); ?></td>
                                        <td><?php echo e($classTeacher?->section?->section_name); ?></td>
                                        <td>
                                            <select name="teacher_id" class="form-control class-teacher-select" data-class-id="<?php echo e($classTeacher->studentClass?->id ?? null); ?>" data-section-id="<?php echo e($classTeacher?->section?->id); ?>" data-id="<?php echo e($classTeacher->id); ?>">
                                                <option value="">-Select Teacher-</option>
                                                <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacherKey => $teacherVal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if($teacherKey == $classTeacher->classTeacher?->id): ?> selected <?php endif; ?> value="<?php echo e($teacherKey ?? 0); ?>"><?php echo e($teacherVal ?? ''); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>

                                        <td class=" justify-content-start">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.assign-class-teacher.edit')): ?>
                                                <a href="<?php echo e(route('class_teachers.edit', $classTeacher->id)); ?>"
                                                    class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.assign-class-teacher.delete')): ?>
                                                <form action="<?php echo e(route('class_teachers.destroy', $classTeacher->id)); ?>" method="POST"
                                                    class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-soft-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this class time period?')"><i class="fas fa-trash"></i></button>
                                                </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {
        // Save previous value before changing (mousedown is more reliable than focus)
        $('.class-teacher-select').on('mousedown', function () {
            $(this).data('prev', $(this).val());
        });
        // Handle change and revert if needed
        $('.class-teacher-select').on('change', function () {
            const $this = $(this);
            const id = $this.data('id');
            const classId = $this.data('class-id');
            const sectionId = $this.data('section-id');
            const selectedTeacherId = $this.val();
            const previousTeacherId = $this.data('prev') ?? ''; // fallback to empty if needed
            $.ajax({
                url: "<?php echo e(route('class_teachers.update.ajax')); ?>",
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id,
                    class_id: classId,
                    section_id: sectionId,
                    teacher_id: selectedTeacherId
                },
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: response.success,
                            timer: 1500,
                            confirmButtonText: 'OK'
                        });
                        // Update previous to new value
                        $this.data('prev', selectedTeacherId);
                    } else if (response.warning) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Warning',
                            text: response.warning,
                            timer: 1500,
                            confirmButtonText: 'OK'
                        });
                        // Revert selection WITHOUT triggering change
                        $this.val(previousTeacherId);
                    }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Something went wrong!',
                        timer: 1500,
                        confirmButtonText: 'OK'
                    });
                    // Optional: revert selection on error
                    $this.val(previousTeacherId);
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/class_teachers/index.blade.php ENDPATH**/ ?>