<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        .attendance_status {
            width: 34px !important;
            height: 34px !important;
            font-weight: bold !important;
            padding-top: 5px !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body card__head">
            <form method="POST" action="<?php echo e(route('student_attendance.search')); ?>" class="row">
                <?php echo csrf_field(); ?>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <?php echo e(generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id"', $shift_id, "Shift")); ?>

                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class_id student_class" id="student_class" name="student_class_id" required', $student_class_id, "Class")); ?>

                </div>

                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <?php echo e(generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id"', $section_id, 'Section')); ?>

                </div>

                <?php if (isset($component)) { $__componentOriginal24102f1ac62c394be69e2bc4df251128 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal24102f1ac62c394be69e2bc4df251128 = $attributes; } ?>
<?php $component = App\View\Components\GroupSelector::resolve(['name' => 'group_id','label' => '','labelText' => 'Group','col' => 'form-group col-lg-2 col-md-4 col-sm-6','required' => (int) request()->input('student_class') >= 11,'selected' => old('group_id') ?? request()->input('group_id')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('group-selector'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\GroupSelector::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['student_class_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute((int) request()->input('student_class'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $attributes = $__attributesOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__attributesOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal24102f1ac62c394be69e2bc4df251128)): ?>
<?php $component = $__componentOriginal24102f1ac62c394be69e2bc4df251128; ?>
<?php unset($__componentOriginal24102f1ac62c394be69e2bc4df251128); ?>
<?php endif; ?>

                
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <input type="date" class="form-control attendance_date" name="attendance_date"
                           value="<?php echo e($attendance_date ?? date("Y-m-d")); ?>" id="attendance_date" readonly required>
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    <button type="submit" class="btn btn-info ">Search</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-4">
        <div class="row">
            <div class="col-md-12">
                <form method="POST" action="<?php echo e(route('student_attendance.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="form-inline">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                <tr>
                                    <th>SN</th>
                                    <th>Roll</th>
                                    <th>Std. ID</th>
                                    <th>Student Name</th>
                                    <th>Action</th>
                                    <th>Note</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(isset($students)): ?>
                                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($student->class_roll); ?></td>
                                            <td><?php echo e($student->student_id_no); ?></td>
                                            <td><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></td>
                                            <td>
                                                <input type="hidden" name="student_id[]" value="<?php echo e($student->id); ?>">
                                                <div class="form-check-inline">
                                                    <label class="form-check-label " for="radioP<?php echo e($student->id); ?>">
                                                        <input type="radio" class="form-check-input"
                                                               id="radioP<?php echo e($student->id); ?>"
                                                               name="attendance_status[<?php echo e($student->id); ?>]" value="P"
                                                               checked>Present
                                                    </label>
                                                </div>
                                                <div class="form-check-inline">
                                                    <label class="form-check-label" for="radioA<?php echo e($student->id); ?>">
                                                        <input
                                                            <?php if(isset($student->attendance->is_absent) && $student->attendance->is_absent == 1): ?> checked
                                                            <?php endif; ?> type="radio" class="form-check-input"
                                                            id="radioA<?php echo e($student->id); ?>"
                                                            name="attendance_status[<?php echo e($student->id); ?>]" value="A">Absent
                                                    </label>
                                                </div>
                                                <div class="form-check-inline">
                                                    <label class="form-check-label" for="radioL<?php echo e($student->id); ?>">
                                                        <input
                                                            <?php if(isset($student->attendance->is_late) && $student->attendance->is_late == 1): ?> checked
                                                            <?php endif; ?> type="radio" class="form-check-input"
                                                            id="radioL<?php echo e($student->id); ?>"
                                                            name="attendance_status[<?php echo e($student->id); ?>]" value="L">Late
                                                    </label>
                                                </div>
                                            </td>
                                            <td>
                                                <input type="text" style="max-width: 100px;" maxlength="50"
                                                       name="note[<?php echo e($student->id); ?>]"
                                                       value="<?php if(!empty($student->attendance->note)): ?> <?php echo e($student->attendance->note); ?> <?php endif; ?>">

                                                <input type="hidden" name="student_class_id[<?php echo e($student->id); ?>]"
                                                       value="<?php if(!empty($student_class_id)): ?> <?php echo e($student_class_id); ?> <?php endif; ?>">
                                                <input type="hidden" name="shift_id"
                                                       value="<?php if(!empty($shift_id)): ?> <?php echo e($shift_id); ?> <?php endif; ?>">
                                                <input type="hidden" name="section_id"
                                                       value="<?php if(!empty($section_id)): ?> <?php echo e($section_id); ?> <?php endif; ?>">
                                                <input type="hidden" class="form-control attendance_date"
                                                       name="attendance_date"
                                                       value="<?php echo e($attendance_date ?? date("Y-m-d")); ?>"
                                                       id="attendance_date" readonly required>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center"> No data available in table</td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                                <?php if(isset($students)): ?>
                                    <tfoot>
                                    <tr>
                                        <td colspan="6">
                                            <button type="submit" class="btn btn-info float-right"
                                                    style="padding:10px;">Save Attendance
                                            </button>
                                        </td>
                                    </tr>
                                    </tfoot>
                                <?php endif; ?>
                            </table>

                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        const shift_id = "<?php echo e($shift_id); ?>";
        const studentAttendance = (event, student_id) => {
            event.preventDefault();
            if (student_id) {
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${student_id}`;
                $.post("<?php echo e(route('student_attendance.store')); ?>", {
                    _token: csrfToken,
                    student_id: student_id,
                    shift_id: shift_id
                }, function (response) {
                    console.log(response)
                    if (response.success) {
                        const icon = response.success ? '<i style="font-size: 1.5rem;color: green;" class="fas fa-check-circle"></i>' : '<i style="font-size: 1.5rem;color: red;" class="fas fa-exclamation-circle"></i>';
                        $(`#icon-${student_id}`).html(icon);
                        $(buttonId).prop('disabled', true);
                    }
                });
            }
        }

        $('.student_class').on('change', function () {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "<?php echo e(isset($student_class_id) ? $student_class_id : ''); ?>";

        if (student_class_id != '') {
            getSection(student_class_id);
        }

        function getSection(student_class_id) {
            let section_id = "<?php echo e(isset($section_id) ? $section_id : ''); ?>";
            if (student_class_id) {
                $.get('<?php echo e(route('sections.list_by_class')); ?>', {student_class_id: student_class_id}, function (response) {
                    let sections = response;

                    let option = '<option value="">--Select Section--</option>';
                    for (let i = 0; i < sections.length; i++) {
                        // if(sections[i].student_class_id == student_class_id){
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name + '</option>';
                        }

                        // }
                    }
                    console.log(option);
                    $('select.section_id').empty().append(option);
                });
            }
        }


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/student_attendance/create.blade.php ENDPATH**/ ?>