<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Teacher Enrollment List</h6>
                <div class="m-0 float-right">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.teacher-enroll.create')): ?>
                        <a class="btn btn-sm btn-light-blue" href="<?php echo e(route('teachers-enroll.create')); ?>">Add New</a>
                    <?php endif; ?>

                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="thead-light">
                            <tr>
                                <th>Teacher</th>
                                <th>Subjects</th>
                                <th class="action__col">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if($enrolls->isNotEmpty()): ?>
                                <?php $__currentLoopData = $enrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($enroll->teacher_name); ?></td>
                                        <td><?php echo e($enroll->subjects_detail); ?> </td>
                                        <td class="d-flex justify-content-start">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.teacher-enroll.edit')): ?>
                                            <a href="<?php echo e(route('teachers-enroll.edit', $enroll->id)); ?>"
                                            class="btn btn-soft-info btn-sm mr-1"><i class="fas fa-edit"></i></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('academic.teacher-enroll.delete')): ?>
                                            <form action="<?php echo e(route('teachers-enroll.destroy', $enroll->id)); ?>"
                                                    method="POST"
                                                    class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-soft-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this branch?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center">No data available in table</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/academic/teacher-enroll/index.blade.php ENDPATH**/ ?>