<?php $__env->startSection('styles'); ?>
    <style>
        .dataTables_wrapper {
            padding-top: 20px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('report.attendance.header-menu', ['active_header' => 'date-to-date-report'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="card mt-4">
        <div class="card-header py-3  card__head">
            <div class="row">
                <div class="col-md-9">
                    <div class="row">
                        <div class="form-group col-md-4 col-lg-4 col-xl-3 mb-3 col-6">
                            <?php echo e(generateDropdown($studentClasses, 'class="form-control student_class" id="student_class_id" name="student_class_id" required', $student_class_id, "Class")); ?>

                        </div>
                        <div class="form-group col-md-4 col-lg-4 col-xl-3 mb-3 col-6">
                            <?php echo e(generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" required', $shift_id, "Shift")); ?>

                        </div>
                        <div class="form-group col-md-4 col-lg-4 col-xl-3 mb-3 col-6">
                            <input type="text" id="reportrange" name="date" class="form-control">
                        </div>
                        <div class="form-group col-md-4 col-lg-4 col-xl-2 xxl-2 mb-3 col-6">
                            <button id="search" onclick="viewTable()" class="btn btn-info">Search</button>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="m-0 float-right" id="column-panel-parent">
                        <a class="btn btn-secondary btn__export" href="#" data-toggle="tooltip" title="Print "
                           onclick="printTable()">
                            <i class="fas fa-print"></i>
                        </a>
                        <a class="btn btn-secondary btn__export" id="excel-btn" href="#" data-toggle="tooltip"
                           title="Download as excel">
                            <i class="fas fa-file-excel"></i>
                        </a>
                        <a class="btn btn-secondary btn__export" id="pdf-btn" href="#" data-toggle="tooltip"
                           title="Download as PDF">
                            <i class="fas fa-file-pdf"></i>
                        </a>
                        <a class="btn btn-secondary btn__export" href="#" data-toggle="collapse"
                           data-target="#column-toggle-panel">
                            <i class="fas fa-columns"></i>
                        </a>
                        <div id="column-toggle-panel" class="collapse border rounded-bottom shadow">
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input" value="student_id"
                                       id="student_id" checked style="display:none;">
                                <label class="column-form-check-label" for="student_id">Student ID</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input" value="roll"
                                       id="roll" checked style="display:none;">
                                <label class="column-form-check-label" for="roll">Roll</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input"
                                       value="student_name" id="student_name" checked style="display:none;">
                                <label class="column-form-check-label" for="student_name">Name</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input"
                                       value="total_present" id="total_present" checked style="display:none;">
                                <label class="column-form-check-label" for="total_present">Total Present</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input"
                                       value="total_absent" id="total_absent" checked style="display:none;">
                                <label class="column-form-check-label" for="total_absent">Total Absent</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input" value="total_late"
                                       id="total_late" checked style="display:none;">
                                <label class="column-form-check-label" for="total_late">Total Late</label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" class="toggle-column column-form-check-input" value="total_days"
                                       id="total_days" checked style="display:none;">
                                <label class="column-form-check-label" for="total_days">Total Days</label>
                            </div>
                            <button class="restorebutton">Restore Visibility</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mt-4">
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table" id="attendance-table">
                        <thead class="thead-light">
                        <tr>
                            <th>Std. ID</th>
                            <th>Roll</th>
                            <th>Name</th>
                            <th>Total Present</th>
                            <th>Total Absent</th>
                            <th>Total Late</th>
                            <th>Total Days</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td colspan="7" class="text-center">No data available in table</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('#pdf-btn').on('click', function (e) {
            e.preventDefault(); // Prevent default link behavior
            // Get filter data
            let date = $('#reportrange').val();
            let student_class_id = $('#student_class_id').val();
            let shift_id = $('#shift_id').val();

            // Check if either student_class_id or shift_id is null
            if (student_class_id == null || student_class_id === '' || shift_id == null || shift_id === '') {
                Swal.fire({
                    icon: 'warning', // Icon type (e.g., 'warning', 'error', 'info', 'success')
                    title: 'Selection Required',
                    text: 'Please select both a class and a shift before searching.',
                    confirmButtonText: 'OK' // Customize the button text
                });
                return; // Prevent the function from proceeding if a required field is missing
            }

            let selectedColumns = [];
            $('.toggle-column:checked').each(function () {
                selectedColumns.push($(this).val());
            });

            $.ajax({
                url: '<?php echo e(route("attendance-date-to-date-pdf-export")); ?>', // Route to handle PDF generation
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>', // Include CSRF token
                    'date': date,
                    'student_class_id': student_class_id,
                    'shift_id': shift_id,
                    'selected_columns': selectedColumns,
                },
                xhrFields: {
                    responseType: 'blob', // Important for downloading files
                },
                success: function (data) {
                    // Create a URL for the file blob
                    const url = window.URL.createObjectURL(new Blob([data]));
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'date-to-date-attendance-report.pdf'; // Set the file name
                    document.body.appendChild(a);
                    a.click();
                    a.remove();
                },
                error: function (xhr) {
                    console.error('Error exporting PDF:', xhr.responseText);
                }
            });
        });

        $('#excel-btn').on('click', function (e) {
            e.preventDefault(); // Prevent default link behavior
            // Get filter data
            let date = $('#reportrange').val();
            let student_class_id = $('#student_class_id').val();
            let shift_id = $('#shift_id').val();

            // Check if either student_class_id or shift_id is null
            if (student_class_id == null || student_class_id === '' || shift_id == null || shift_id === '') {
                Swal.fire({
                    icon: 'warning', // Icon type (e.g., 'warning', 'error', 'info', 'success')
                    title: 'Selection Required',
                    text: 'Please select both a class and a shift before searching.',
                    confirmButtonText: 'OK' // Customize the button text
                });
                return; // Prevent the function from proceeding if a required field is missing
            }

            let selectedColumns = [];
            $('.toggle-column:checked').each(function () {
                selectedColumns.push($(this).val());
            });
            $.ajax({
                url: '<?php echo e(route("attendance-date-to-date-excel-export")); ?>',
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>', // Include CSRF token
                    'date': date,
                    'student_class_id': student_class_id,
                    'shift_id': shift_id,
                    'selected_columns': selectedColumns,
                },
                xhrFields: {
                    responseType: 'blob', // Important for downloading files
                },
                success: function (data) {
                    console.log(data);
                    // Create a URL for the file blob
                    const url = window.URL.createObjectURL(new Blob([data]));
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'date-to-date-attendance-report.xlsx'; // Set the file name
                    document.body.appendChild(a);
                    a.click();
                    a.remove();
                },
                error: function (xhr) {
                    console.error('Error exporting Excel:', xhr.responseText);
                }
            });
        });


        function restoreDefaultColumns() {
            // Set the default checked states
            $('#student_id').prop('checked', true);
            $('#roll').prop('checked', true);
            $('#student_name').prop('checked', true);
            $('#total_present').prop('checked', true);
            $('#total_absent').prop('checked', true);
            $('#total_late').prop('checked', true);
            $('#total_days').prop('checked', true);
            // Reinitialize the table with the default column selection
            viewTable();
        }

        // Event listener for the "Restore Visibility" button
        $('.restorebutton').on('click', function () {
            restoreDefaultColumns();
        });

        let table; // Store DataTable instance
        // viewTable(); // Initial table load
        function viewTable() {
            // Get filter data
            let date = $('#reportrange').val();
            let student_class_id = $('#student_class_id').val();
            let shift_id = $('#shift_id').val();

            // Check if either student_class_id or shift_id is null
            if (student_class_id == null || student_class_id === '' || shift_id == null || shift_id === '') {
                Swal.fire({
                    icon: 'warning', // Icon type (e.g., 'warning', 'error', 'info', 'success')
                    title: 'Selection Required',
                    text: 'Please select both a class and a shift before searching.',
                    confirmButtonText: 'OK' // Customize the button text
                });
                return; // Prevent the function from proceeding if a required field is missing
            }


            // Collect selected columns
            let selectedColumns = [];
            $('.toggle-column:checked').each(function () {
                selectedColumns.push($(this).val());
            });

            // Define column configurations and headers
            let columns = [];
            let columnHeaders = [];
            // Define columns dynamically
            columns.push({data: 'student_id', name: 'student_id', searchable: true});
            columnHeaders.push('Student ID');

            if (selectedColumns.includes('roll')) {
                columns.push({data: 'roll', name: 'roll',});
                columnHeaders.push('Roll');
            }
            if (selectedColumns.includes('student_name')) {
                columns.push({data: 'student_name', name: 'student_name',});
                columnHeaders.push('Name');
            }
            if (selectedColumns.includes('total_present')) {
                columns.push({data: 'total_present', name: 'total_present',});
                columnHeaders.push('Total Present');
            }
            if (selectedColumns.includes('total_absent')) {
                columns.push({data: 'total_absent', name: 'total_absent',});
                columnHeaders.push('Total Absent');
            }
            if (selectedColumns.includes('total_late')) {
                columns.push({data: 'total_late', name: 'total_late',});
                columnHeaders.push('Total Late');
            }
            if (selectedColumns.includes('total_days')) {
                columns.push({data: 'total_days', name: 'total_days',});
                columnHeaders.push('Total Days');
            }

            // If no columns are selected, show a custom message
            if (columns.length === 0) {
                // Destroy any previous DataTable instance if it exists
                if ($.fn.DataTable.isDataTable('#attendance-table')) {
                    $('#attendance-table').DataTable().clear().destroy();
                }

                // Initialize DataTable with no columns
                table = $('#attendance-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "<?php echo e(route('attendance-date-to-date-report-search')); ?>",
                        type: "POST",
                        data: function (d) {
                            d.selected_columns = selectedColumns; // Pass empty selected columns
                        },
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    },
                    columns: [], // No columns when none selected
                    language: {
                        processing: "<span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span> Loading..."
                    },
                    paging: true,
                    info: true,
                    lengthChange: false,
                    searching: false,
                    ordering: false
                });
            } else {
                // Destroy previous DataTable if it exists
                if ($.fn.DataTable.isDataTable('#attendance-table')) {
                    $('#attendance-table').DataTable().clear().destroy();
                }
                // Rebuild table headers
                const thead = $('#attendance-table').find('thead');
                thead.empty();
                let headerRow = $('<tr></tr>');
                columnHeaders.forEach(header => {
                    headerRow.append(`<th>${header}</th>`);
                });
                thead.append(headerRow);

                // Destroy existing DataTable instance if it exists
                if ($.fn.DataTable.isDataTable('#attendance-table')) {
                    $('#attendance-table').DataTable().clear().destroy();
                }

                // Initialize DataTable
                table = $('#attendance-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "<?php echo e(route('attendance-date-to-date-report-search')); ?>",
                        type: "POST",
                        data: function (d) {
                            d.selected_columns = selectedColumns;
                            d.date = date;
                            d.student_class_id = student_class_id;
                            d.shift_id = shift_id;
                        },
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    },
                    columns: columns,
                    language: {
                        processing: "<span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span> Loading..."
                    },
                    responsive: true,
                    paging: true,
                    info: true,
                    lengthChange: true,
                    searching: true,
                    ordering: true
                });
            }
        }

        $(document).on('change', '.toggle-column', function () {
            // Reinitialize table when column visibility changes
            viewTable();
        });


        // print function
        function printTable() {

            let reportrange = $('#reportrange').val();
            // Split the date range into start and end dates
            const [startDate, endDate] = reportrange.split(' - ');
            // Function to reformat a date from DD/MM/YYYY to YYYY-MM-DD
            const reformatDate = (date) => {
                const [day, month, year] = date.split('/');
                return `${day}-${month}-${year}`;
            };
            // Reformat the dates
            const formattedStartDate = reformatDate(startDate);
            const formattedEndDate = reformatDate(endDate);

            let selected_class = $('#student_class_id option:selected').text();
            let selected_shift = $('#shift_id option:selected').text();
            let student_class_id = $('#student_class_id').val();
            let shift_id = $('#shift_id').val();

            // Check if either student_class_id or shift_id is null
            if (student_class_id == null || student_class_id === '' || shift_id == null || shift_id === '') {
                Swal.fire({
                    icon: 'warning', // Icon type (e.g., 'warning', 'error', 'info', 'success')
                    title: 'Selection Required',
                    text: 'Please select both a class and a shift before searching.',
                    confirmButtonText: 'OK' // Customize the button text
                });
                return; // Prevent the function from proceeding if a required field is missing
            }

            var selectedColumns = [];
            $('.toggle-column:checked').each(function () {
                selectedColumns.push($(this).val());
            });

            let columns = [];
            let columnHeaders = [];

            if (selectedColumns.includes('student_id')) {
                columns.push({data: 'student_id', name: 'student_id'});
                columnHeaders.push('Student ID');
            }
            if (selectedColumns.includes('roll')) {
                columns.push({data: 'roll', name: 'roll'});
                columnHeaders.push('Roll');
            }
            if (selectedColumns.includes('student_name')) {
                columns.push({data: 'student_name', name: 'student_name'});
                columnHeaders.push('Name');
            }
            if (selectedColumns.includes('total_present')) {
                columns.push({data: 'total_present', name: 'total_present'});
                columnHeaders.push('Total Present');
            }
            if (selectedColumns.includes('total_absent')) {
                columns.push({data: 'total_absent', name: 'total_absent'});
                columnHeaders.push('Total Absent');
            }
            if (selectedColumns.includes('total_late')) {
                columns.push({data: 'total_late', name: 'total_late'});
                columnHeaders.push('Total Late');
            }
            if (selectedColumns.includes('total_days')) {
                columns.push({data: 'total_days', name: 'total_days'});
                columnHeaders.push('Total Days');
            }

            let tableContent = '<table border="1" style="width: 100%; border-collapse: collapse;">';

            tableContent += '<thead><tr>';
            columnHeaders.forEach(function (header) {
                tableContent += '<th style="border: 1px solid #ccc;padding: 5px;text-align: center;">' + header + '</th>';
            });
            tableContent += '</tr></thead><tbody>';

            let hasData = false;
            $('#transport tbody tr').each(function () {
                hasData = true;
                tableContent += '<tr>';
                $(this).find('td').each(function (index) {
                    if (columns[index]) {
                        tableContent += '<td style="border: 1px solid #ccc;padding: 5px;text-align: center;">' + $(this).text() + '</td>';
                    }
                });
                tableContent += '</tr>';
            });

            if (!hasData) {
                tableContent += '<tr><td colspan="7" class="text-center">No data available in table</td></tr>';
            }

            tableContent += '</tbody></table>';

            const logoUrl = "<?php echo e(get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('uploads/images/logo.png') ?? ''); ?>";
            const instituteName = "<?php echo e(get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : ''); ?>";
            const branch_address = "<?php echo e(get_branch_info()->address ? get_branch_info()->address : ''); ?>";
            const branch_contact_info = "<?php echo e(get_branch_info()->contact_info ? get_branch_info()->contact_info : ''); ?>";
            const currentDate1 = new Date();
            const currentDate = currentDate1.toLocaleDateString('en-GB').replace(/\//g, '-');
            const primaryInfo = $("#primary-info").html();

            let printWindow = window.open('', '', 'height=800,width=1200');
            printWindow.document.write('<html><head><title>Print</title><style>');
            // Add CSS for alignment
            printWindow.document.write(`<style>
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding: 0 20px; /* Add padding to create space between edges and text */
        }
        .header-left {
            text-align: left;
            font-size: 14px;
            font-weight: bold; /* Make hostel name bold */
            flex: 1; /* Ensures it takes available space on the left */
        }
        .header-right {
            text-align: right;
            font-size: 14px;
            font-weight: bold; /* Make date bold */
        }
        table, th, td {
            border: 1px solid #ccc !important; /* Apply border color with high specificity */
            border-collapse: collapse;
        }
        th {
            font-family: sans-serif;
            text-align: center;
            padding: 10px 8px !important;
            background: #eaecf4;
            font-weight: 400 !important;
        }
        td {
            text-align: center;
            padding: 8px;
            color: #292929;
        }
        tr {
            border: 1px solid #ccc; /* Ensure row borders are styled */
        }
        td, th {
            border-color: #ccc; /* Explicitly set border color for td and th */
        }
    </style>`);
            printWindow.document.write('</style></head><body>');
            printWindow.document.write('<div style="text-align: center; margin-bottom: 20px;font-family: sans-serif;color:#1d1d1d ;">');
            printWindow.document.write('<img src="' + logoUrl + '" alt="Institute Logo" style="height: 80px;padding-bottom:10px !important;">');
            printWindow.document.write('<h2 style="margin: 0;">' + instituteName + '</h2>');
            printWindow.document.write('<p style="margin: 0;">' + branch_address + '</p>');
            printWindow.document.write('<p style="margin: 0;">' + branch_contact_info + '</h2>');
            printWindow.document.write('<p style="margin: 0;"><strong>Date To Date Attendance Report</strong></p>');
            printWindow.document.write('</div>');

            //table top info
            printWindow.document.write('<div class="table-top">');
            printWindow.document.write('<table style="border: none !important; width: 100%; margin: 0px 0px 10px 0px; padding: 0px;">');
            printWindow.document.write('<tbody><tr style="width: 100%;border: none !important;">');
            printWindow.document.write('<td style="text-align: left; width: 80%;border: none !important;padding: 0px;"><strong>Class: </strong>' + selected_class + '<strong> Shift: </strong>' + selected_shift + '<strong> Date: </strong>' + formattedStartDate + ' <strong>To</strong> ' + formattedEndDate + '</td>');
            printWindow.document.write('<td style="text-align: right; width: 20%;border: none !important;padding: 0px;"> <strong>Date: </strong>' + currentDate + '</td>');
            printWindow.document.write('</tr></tbody></table>');
            printWindow.document.write('</div>');

            printWindow.document.write(tableContent);
            printWindow.document.write('</body></html>');
            printWindow.document.close();

            // Attach the onafterprint event
            printWindow.onafterprint = function () {
                printWindow.close();
            };

            // Add a delay to ensure resources are loaded before printing
            setTimeout(() => {
                printWindow.print();
            }, 500);
        }

        // print function
        function printTable22() {
            var selectedColumns = [];
            $('.toggle-column:checked').each(function () {
                selectedColumns.push($(this).val());
            });

            let columns = [];
            let columnHeaders = [];

            if (selectedColumns.includes('student_id')) {
                columns.push({data: 'student_id', name: 'student_id'});
                columnHeaders.push('Student ID');
            }
            if (selectedColumns.includes('roll')) {
                columns.push({data: 'roll', name: 'roll'});
                columnHeaders.push('Roll');
            }
            if (selectedColumns.includes('student_name')) {
                columns.push({data: 'student_name', name: 'student_name'});
                columnHeaders.push('Name');
            }
            if (selectedColumns.includes('total_present')) {
                columns.push({data: 'total_present', name: 'total_present'});
                columnHeaders.push('Total Present');
            }
            if (selectedColumns.includes('total_absent')) {
                columns.push({data: 'total_absent', name: 'total_absent'});
                columnHeaders.push('Total Absent');
            }
            if (selectedColumns.includes('total_late')) {
                columns.push({data: 'total_late', name: 'total_late'});
                columnHeaders.push('Total Late');
            }
            if (selectedColumns.includes('total_days')) {
                columns.push({data: 'total_days', name: 'total_days'});
                columnHeaders.push('Total Days');
            }

            let tableContent = '<table border="1" style="width: 100%; border-collapse: collapse;">';

            tableContent += '<thead><tr>';
            columnHeaders.forEach(function (header) {
                tableContent += '<th>' + header + '</th>';
            });
            tableContent += '</tr></thead><tbody>';

            let hasData = false;
            $('#attendance-table tbody tr').each(function () {
                hasData = true;
                tableContent += '<tr>';
                $(this).find('td').each(function (index) {
                    if (columns[index]) {
                        tableContent += '<td>' + $(this).text() + '</td>';
                    }
                });
                tableContent += '</tr>';
            });

            if (!hasData) {
                tableContent += '<tr><td colspan="7" class="text-center">No data available in table</td></tr>';
            }

            tableContent += '</tbody></table>';

            const logoUrl = "<?php echo e(get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('uploads/images/logo.png') ?? ''); ?>";
            const instituteName = "<?php echo e(get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : ''); ?>";

            let printWindow = window.open('', '', 'height=800,width=1200');
            printWindow.document.write('<html><head><title>Print</title></head><body>');
            printWindow.document.write('<div style="text-align: center; margin-bottom: 20px;">');
            printWindow.document.write('<img src="' + logoUrl + '" alt="Institute Logo" style="height: 80px;">');
            printWindow.document.write('<h2 style="margin: 0;">' + instituteName + '</h2>');
            printWindow.document.write('<h3 style="margin: 0;"><strong>Attendance Report:</strong> Date To Date Attendance Report</h3>');
            printWindow.document.write('</div>');
            printWindow.document.write(tableContent);
            printWindow.document.write('</body></html>');
            printWindow.document.close();

            // Attach the onafterprint event
            printWindow.onafterprint = function () {
                printWindow.close();
            };

            // Add a delay to ensure resources are loaded before printing
            setTimeout(() => {
                printWindow.print();
            }, 500);
        }


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/report/attendance/date-to-date-report.blade.php ENDPATH**/ ?>