<?php $__env->startSection('content'); ?>


    <div class="container-fluid my__cl__mate">
        <div class="row">
            <div class="col-12 col-lg-12 col-xl-10 m-auto">
                <div class="page-header">
                    <div class="page-block mb-0 mt-3">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">My Fees</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="data__table mt-4">
                    <div class="card-body table-border-style">
                        <!-- Desktop View (Table) -->
                        <div class="d-none d-md-block">
                            <div class="table-responsive py-2">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Month</th>
                                        <th class="h_stl_2 text-center">Total Amount</th>
                                        <th class="text-center">Paid Amount</th>
                                        <th class="text-center">Due Amount</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody class="day-schedule">

                                    <?php $__empty_1 = true; $__currentLoopData = $myFees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $myFee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="subject-entry">
                                            <td><?php echo e(!empty($myFee['month']) ? date('F', mktime(0, 0, 0, $myFee['month'], 1)) : '--'); ?></td>
                                            <td class="b_stl_2 text-center"><?php echo e(round($myFee['total_amount']) ?? '0'); ?></td>
                                            <td class="text-center"><?php echo e(round($myFee['paid_amount']) ?? '0'); ?></td>
                                            <td class="text-center"><?php echo e(round($myFee['due_amount']) ?? '0'); ?></td>
                                            <td class="text-center">
                                                <?php if($myFee['due_amount'] > 0): ?>
                                                    <?php echo getStudentStatusBadge(Status::DUE); ?>

                                                <?php elseif($myFee['due_amount'] == 0 && $myFee['paid_amount'] > 0): ?>
                                                    <?php echo getStudentStatusBadge(Status::PAID); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center">
                                                <?php if($myFee['due_amount'] > 0): ?>
                                                    <a href="" class="badge bg-primary">Pay</a>
                                                <?php elseif($myFee['due_amount'] == 0 && $myFee['paid_amount'] > 0): ?>
                                                    <span class="badge bg-success">View</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <td colspan="5" class="text-center">No classes scheduled for this day.</td>
                                    <?php endif; ?>

                                    <?php
                                        $totalAssignedFee = $myFees->sum('total_amount');
                                        $totalPaidFee = $myFees->sum('paid_amount');
                                        $totalDueFee = $myFees->sum('due_amount');
                                    ?>

                                    <tr class="table-secondary fw-bold">
                                        <td colspan="1">Grand Total</td>
                                        <td class="text-center"><?php echo e(round($totalAssignedFee)); ?></td>
                                        <td class="text-center"><?php echo e(round($totalPaidFee)); ?></td>
                                        <td class="text-center"><?php echo e(round($totalDueFee)); ?></td>
                                        <td colspan="2"></td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile View (Cards) -->
                        <div class="fee__summary d-md-none">
                            <div class="card mb-4 bg-light bg__style1">
                                <div class="card-body">
                                    <h6 class="card-title mb-3">Fees Summary</h6>
                                    <div class="row g-3">
                                        <div class="col-4">
                                            <div class="item text-center">
                                                <small class="text-muted d-block">Total Amount</small>
                                                <div class="fw-bold amount"><?php echo e(round($totalAssignedFee)); ?></div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="item text-center">
                                                <small class="text-muted d-block">Total Paid</small>
                                                <div class="fw-bold text-success"><?php echo e(round($totalPaidFee)); ?></div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="item text-center">
                                                <small class="text-muted d-block">Total Due</small>
                                                <div class="fw-bold text-danger"><?php echo e(round($totalDueFee)); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $__empty_1 = true; $__currentLoopData = $myFees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $myFee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="card mb-3 fee-card">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            
                                            <?php if($myFee['due_amount'] > 0): ?>
                                                <?php echo getStudentStatusBadge(Status::DUE); ?>

                                            <?php elseif($myFee['due_amount'] == 0 && $myFee['paid_amount'] > 0): ?>
                                                <?php echo getStudentStatusBadge(Status::PAID); ?>

                                            <?php endif; ?>
                                        </div>
                                        <div class="fee-details">
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <small class="text-muted">Month:</small>
                                                    <div><?php echo e(!empty($myFee['month']) ? date('F', mktime(0, 0, 0, $myFee['month'], 1)) : '--'); ?></div>
                                                </div>
                                                <div class="col-6">
                                                    <small class="text-muted">Total Amount:</small>
                                                    <div><?php echo e(round($myFee['total_amount']) ?? '0'); ?></div>
                                                </div>
                                                <div class="col-6">
                                                    <small class="text-muted">Paid Amount:</small>
                                                    <div><?php echo e(round($myFee['paid_amount']) ?? '0'); ?></div>
                                                </div>
                                                <div class="col-6">
                                                    <small class="text-muted">Due Amount:</small>
                                                    <div><?php echo e(round($myFee['due_amount']) ?? '0'); ?></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mt-3 text-end">
                                            <?php if($myFee['due_amount'] > 0): ?>
                                                <a href="" class="btn btn-primary btn-sm">Pay Now</a>
                                            <?php elseif($myFee['due_amount'] == 0 && $myFee['paid_amount'] > 0): ?>
                                                <button class="btn btn-success btn-sm">View Details</button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center py-4">
                                    <p class="text-muted mb-0">No fees found.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <style>
        .fee-card {
            border: 1px solid rgba(0, 0, 0, .125);
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
            transition: all 0.3s ease;
        }

        .fee-card:hover {
            box-shadow: 0 4px 8px rgba(0, 0, 0, .1);
        }

        .fee-details {
            background-color: #f8f9fa;
            padding: 1rem;
            border-radius: 0.375rem;
            margin-top: 0.5rem;
        }

        /* Add these new styles for table */
        .table thead th {
            color: #333;
        }

        .table tbody td {
            color: #333;
        }

        .subject-entry td {
            color: #333;
        }

        .table-secondary {
            background-color: #f8f9fa;
        }

        .fw-bold {
            font-weight: 600;
        }

        .text-success {
            color: #28a745;
        }

        .text-danger {
            color: #dc3545;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('students-dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/students-dashboard/pages/my-fees.blade.php ENDPATH**/ ?>