<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body card__head">
            <form method="get" action="<?php echo e(route('markHeadAssign.index')); ?>" class="row">
                <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                    <select name="exam" class="form-control select2 exam_id" id="exam" required>
                        <option value="">Select Exam</option>
                        <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($examItem->id); ?>" <?php if($exam_id == $examItem->id || (!$exam_id && $loop->first)): echo 'selected'; endif; ?>>
                                <?php echo e($examItem->exam_name . ' ' . $examItem->academic_year->year); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group col-lg-4 col-xl-2 col-xxl-2 col-md-6 col-6">
                    <?php echo e(generateDropdown($studentClasses, 'class="form-control select2" id="student_class" name="student_class"', $student_class_id, 'Select Class')); ?>

                </div>
                <div class="form-group col-lg-2 col-md-3 col-sm-3">
                    <button type="submit" class="btn btn-info">Search</button>
                    <a class="btn btn-success" href="<?php echo e(route('markHeadAssign.copy.create')); ?>">Copy</a>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Assigned List</h6>
            <div class="m-0 float-right">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.assign-head.create')): ?>
                    <a class="btn btn-sm btn-light-blue" href="<?php echo e(route('markHeadAssign.create')); ?>">Add New</a>
                <?php endif; ?>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-left">Exam</th>
                                <th class="text-left">Class</th>
                                <th class="text-left">Subject</th>
                                <th class="text-left">Head Marks</th>
                                <th class="action__col">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($assignMarksHead->isNotEmpty()): ?>

                                <?php $__currentLoopData = $assignMarksHead; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classGroups): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <?php $__currentLoopData = $classGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $a_head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $head_marks = json_decode($a_head->head_marks, true);
                                        ?>

                                        <tr>
                                            <?php if($index == 0): ?>
                                                <td class="text-left" rowspan="<?php echo e($classGroups->count()); ?>">
                                                    <?php echo e($a_head->exam->exam_name); ?>

                                                    <?php echo e($a_head->exam->academic_year->year); ?>

                                                </td>

                                                <td class="text-left" rowspan="<?php echo e($classGroups->count()); ?>">
                                                    <?php echo e($a_head->studentClass->class_name); ?>

                                                </td>
                                            <?php endif; ?>

                                            <td class="text-left">
                                                <?php echo e($a_head->subject->subject_name); ?>

                                            </td>

                                            <td class="text-left">
                                                <?php $__currentLoopData = $head_marks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head_id => $marks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge badge-light p-2 m-1">
                                                        <?php echo e($mark_heads[$head_id] ?? 'Unknown Head'); ?>: <?php echo e($marks); ?>

                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>

                                            <?php if($index == 0): ?>
                                                <td rowspan="<?php echo e($classGroups->count()); ?>">
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-result.assign-head.edit')): ?>
                                                        <a href="<?php echo e(route('markHeadAssign.edit', [$a_head->studentClass->id, $a_head->exam_id])); ?>"
                                                            class="btn btn-soft-info btn-sm mr-1">
                                                            <i class="fas fa-edit"></i>
                                                        </a>

                                                        <form
                                                            action="<?php echo e(route('markHeadAssign.destroy', [$a_head->studentClass->id, $a_head->exam_id])); ?>"
                                                            method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="btn btn-soft-danger btn-sm"
                                                                onclick="return confirm('Are you sure?')">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" class="text-center">
                                        There is no data. Search with exam & class to see list.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/result/mark_head_assign/index.blade.php ENDPATH**/ ?>