<?php if($containerClass): ?><div class="<?php echo e($containerClass); ?>"><?php endif; ?>
    <div class="<?php echo e($groupClass); ?>">
        <label for="<?php echo e($prefix); ?>division_id" class="<?php echo e($labelClass); ?>">Division</label>
        <select class="<?php echo e($selectClass); ?>" id="<?php echo e($prefix); ?>division_id" name="<?php echo e($prefix); ?>division_id">
            <option value="">Select Division</option>
            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($division->id); ?>" <?php echo e($selectedDivision == $division->id ? 'selected' : ''); ?>>
                    <?php echo e($division->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    

    <div class="<?php echo e($groupClass); ?>">
        <label for="<?php echo e($prefix); ?>district_id" class="<?php echo e($labelClass); ?>">District</label>

        <select class="<?php echo e($selectClass); ?>" id="<?php echo e($prefix); ?>district_id" name="<?php echo e($prefix); ?>district_id">
            <option value="">Select District</option>
            <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($district->id); ?>" <?php echo e($selectedDistrict == $district->id ? 'selected' : ''); ?>>
                    <?php echo e($district->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

    </div>

    <div class="<?php echo e($groupClass); ?>">
        <label for="<?php echo e($prefix); ?>upazila_id" class="<?php echo e($labelClass); ?>">Upazila</label>
        <select class="<?php echo e($selectClass); ?>" id="<?php echo e($prefix); ?>upazila_id" name="<?php echo e($prefix); ?>upazila_id">
            <option value="">Select Upazila</option>
        </select>
    </div>

    
<?php if($containerClass): ?></div><?php endif; ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Function to load dropdown options
    function loadDropdownOptions(url, targetDropdown, selectedId = null, params = {}) {
        $.ajax({
            url: url,
            type: 'GET',
            data: params,
            success: function(data) {
                let options = '<option value="">Select Option</option>';
                data.forEach(function(item) {
                    options += `<option value="${item.id}" ${selectedId == item.id ? 'selected' : ''}>${item.name}</option>`;
                });
                $(targetDropdown).html(options);
            }
        });
    }

    let divisionId = `<?php echo e($selectedDivision); ?>`;
    let districtId = `<?php echo e($selectedDistrict); ?>`;
    let upazilaId = `<?php echo e($selectedUpazila); ?>`;
    let unionId = `<?php echo e($selectedUnion); ?>`;

    if (divisionId) {
        loadDropdownOptions("<?php echo e(route('locations.districts')); ?>", '#<?php echo e($prefix); ?>district_id', districtId, {
            division_id: divisionId
        });
    }

    if (districtId) {
        loadDropdownOptions("<?php echo e(route('locations.upazilas')); ?>", '#<?php echo e($prefix); ?>upazila_id', upazilaId, {
            district_id: districtId
        });
    }
    
    if (upazilaId) {
        loadDropdownOptions("<?php echo e(route('locations.unions')); ?>", '#<?php echo e($prefix); ?>union_id', unionId, {
            upazila_id: upazilaId
        });
    }

    // Division change event

    $('#<?php echo e($prefix); ?>division_id').change(function() {
        const divisionId = $(this).val();
        if (divisionId) {
            loadDropdownOptions("<?php echo e(route('locations.districts')); ?>", '#<?php echo e($prefix); ?>district_id', districtId, {
                division_id: divisionId
            });
            $('#<?php echo e($prefix); ?>upazila_id').html('<option value="">Select Upazila</option>');
            $('#<?php echo e($prefix); ?>union_id').html('<option value="">Select Union</option>');
        }
    });

    // District change event
    $('#<?php echo e($prefix); ?>district_id').change(function() {
        const districtId = $(this).val();
        if (districtId) {
            loadDropdownOptions("<?php echo e(route('locations.upazilas')); ?>", '#<?php echo e($prefix); ?>upazila_id', upazilaId, {
                district_id: districtId
            });
            $('#<?php echo e($prefix); ?>union_id').html('<option value="">Select Union</option>');
        }
    });

    // Upazila change event
    $('#<?php echo e($prefix); ?>upazila_id').change(function() {
        const upazilaId = $(this).val();
        if (upazilaId) {
            loadDropdownOptions("<?php echo e(route('locations.unions')); ?>", '#<?php echo e($prefix); ?>union_id', unionId, {
                upazila_id: upazilaId
            });
        }
    });
});
</script>
<?php $__env->stopPush(); ?> <?php /**PATH /var/www/html/EdueasyCollege/resources/views/components/location-dropdown.blade.php ENDPATH**/ ?>