<?php $__env->startSection('content'); ?>
<?php if(isset($error)): ?>
    <div class="alert alert-danger"><?php echo e($error); ?></div>
<?php endif; ?>
<div class="card">
    <div class="card-body card__head">
        <form action="<?php echo e(route('student.graduation.create')); ?>" method="GET">
            <div class="row mb-3">
                <div class="col-lg-12 p-3">
                    <label>From : </label>
                    <div class="row">
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <?php echo e(generateDropdown($shifts, 'class="form-control from_shift" id="from_shift" name="from_shift"', request()->query('from_shift'), "Shift")); ?>

                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <?php echo e(generateDropdown($classes, 'class="form-control from_class" id="from_class" name="from_class"', request()->query('from_class'), 'From Class')); ?>

                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <?php echo e(generateDropdown([], 'class="form-control from_section" id="from_section" name="from_section"', request()->query('from_section') ?? '', 'From Section')); ?>

                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <?php echo e(generateDropdown($academicYears, 'class="form-control academic_year" id="from_academic_year" name="from_academic_year" required', request()->query('from_academic_year'), "From Year")); ?>

                        </div>
                        <div class="col-lg-2 col-md-4 col-sm-6">
                            <button type="submit" class="btn btn-primary">Search</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Student List</h6>
    </div>
    
    <form action="<?php echo e(route('student.graduation.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="table-responsive">  
            <table class="table">
                <thead>
                    <tr>
                        <th>
                            <input type="checkbox" id="select_all"> Select All
                        </th>
                        <th>Student ID</th>
                        <th>Name</th>
                        <th>Current Roll</th>
                        <th>Merit Position</th>
                        <th>Total Obt. Marks</th>
                        <th>Result Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($students)): ?>
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($student->status == 'Fail' ? 'table-danger' : ''); ?>">
                                <td>
                                    <input type="checkbox" class="student-checkbox" name="student_ids[]" value="<?php echo e($student->id); ?>">
                                    <input type="hidden" name="from_department[<?php echo e($student->id); ?>]" value="<?php echo e($student->department); ?>">
                                    <input type="hidden" name="to_section[<?php echo e($student->id); ?>]" value="<?php echo e(request()->query('to_section')); ?>">
                                    <input type="hidden" name="previous_roll_number[<?php echo e($student->id); ?>]" value="<?php echo e($student->current_position); ?>">
                                    <input type="hidden" name="current_roll_number[<?php echo e($student->id); ?>]" value="<?php echo e($student->merit_position); ?>">
                                </td>
                                <td><?php echo e($student->student_id_no); ?></td>
                                <td><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></td>
                                <td><?php echo e($student->current_position); ?></td>
                                <td><?php echo e($student->merit_position); ?></td>
                                <td><?php echo e(number_format($student->total_marks)); ?> </td>
                                <td>
                                    <span class="badge badge-<?php echo e($student->status == 'Pass' ? 'success' : ($student->status == 'Fail' ? 'danger' : 'warning')); ?>">
                                        <?php echo e($student->status); ?>

                                    </span>
                                </td>
                                
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <input type="hidden" name="from_shift" value="<?php echo e(request()->query('from_shift')); ?>">
                        <input type="hidden" name="from_class" value="<?php echo e(request()->query('from_class')); ?>">
                        <input type="hidden" name="from_section" value="<?php echo e(request()->query('from_section')); ?>">
                        <input type="hidden" name="to_academic_year" value="<?php echo e(request()->query('to_academic_year')); ?>">

                        <input type="hidden" name="to_shift" value="<?php echo e(request()->query('to_shift')); ?>">
                        <input type="hidden" name="to_class" value="<?php echo e(request()->query('to_class')); ?>">
                        <input type="hidden" name="from_academic_year" value="<?php echo e(request()->query('from_academic_year')); ?>">
                    <?php else: ?>
                        <tr>
                            <td colspan="11" class="text-center">No data found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if(isset($students)): ?>
            <div class="card-footer d-flex justify-content-end">
                <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to graduate these students?')">Graduate Selected Students</button>
            </div>
        <?php endif; ?>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            //form class wise section

            let from_class_id = "<?php echo e(request()->query('from_class') ?? ''); ?>";
            let from_section_id = "<?php echo e(request()->query('from_section') ?? ''); ?>";

            if(from_class_id!=''){
                getSection(from_class_id, from_section_id).then(sections => {
                    let option = '<option value="">From Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if(from_section_id==sections[i].id){
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        }else{
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.from_section').empty().append(option);
                });
            }

            $('.from_class').on('change', function() {
                let from_class_id = $(this).val();
                getSection(from_class_id, from_section_id).then(sections => {
                    let option = '<option value="">From Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if(from_section_id==sections[i].id){
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        }else{
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.from_section').empty().append(option);
                });
            });

            //to class wise section same as from class wise section
            let to_class_id = "<?php echo e(request()->query('to_class') ?? ''); ?>";
            let to_section_id = "<?php echo e(request()->query('to_section') ?? ''); ?>";
            if(to_class_id!=''){
                getSection(to_class_id, to_section_id).then(sections => {
                    let option = '<option value="">To Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if(to_section_id==sections[i].id){
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        }else{
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.to_section').empty().append(option);
                });
            }

            $('.to_class').on('change', function(){
                let to_class_id = $('.to_class').val();
                getSection(to_class_id, to_section_id).then(sections => {
                    let option = '<option value="">To Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if(to_section_id==sections[i].id){
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name + '</option>';
                        }else{
                            option += '<option value=' + sections[i].id + '>' + sections[i].section_name + '</option>';
                        }
                    }
                    $('.to_section').empty().append(option);
                });
            });

            function getSection(student_class_id, selected_section_id) {
                return new Promise((resolve) => {
                    if (student_class_id) {
                        $.get('<?php echo e(route('sections.list_by_class')); ?>', { student_class_id: student_class_id }, function(response) {
                            console.log('response', response);
                            resolve(response);
                        });
                    } else {
                        resolve([]);
                    }
                });
            }

            // Select All functionality
            $('#select_all').on('change', function() {
                $('.student-checkbox').prop('checked', this.checked);
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/pages/students/graduation/create.blade.php ENDPATH**/ ?>