<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5 class="text-gray-900 text-capitalize">Role: <?php echo e($role->name); ?> </h5>
        <a href="<?php echo e(route('roles.index')); ?>" class="btn btn-sm btn-light-blue">View All</a>
    </div>
    <div class="card-body">
        <?php if($hierarchicalPermissions->count()>0): ?>
            <form action="<?php echo e(route('roles.assign-permission',$role->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Module</th>
                                <th>Permissions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $hierarchicalPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryName => $categories): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="align-middle" style="min-width: 200px;">
                                        <div class="d-flex align-items-center justify-content-start">
                                            <div class="mr-3 mt-1">
                                                <input type="checkbox" class="category-checkbox" data-category="<?php echo e($categoryName); ?>">
                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-left">
                                                    <?php if(isset($categories['standalone'][0])): ?>
                                                        <?php echo e(ucfirst(ucwords(str_replace('-', ' ', $categories['standalone'][0]['display_name'])))); ?>

                                                    <?php else: ?>
                                                        No Display Name
                                                    <?php endif; ?>
                                                </h6>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <!-- Standalone Permissions -->


















                                        <!-- Grouped Permissions -->
                                        <?php $__currentLoopData = $categories['grouped']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategoryName => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="mb-3">
                                                <div class="d-flex align-items-center mb-2">
                                                    <input type="checkbox" class="subcategory-checkbox mr-1"
                                                        data-subcategory="<?php echo e($subCategoryName); ?>"
                                                        data-category="<?php echo e($categoryName); ?>">
                                                    <h6 class="mb-0"><b><?php echo e(ucfirst(str_replace('-', ' ', $subCategoryName))); ?></b></h6>
                                                </div>
                                                <div class="row g-2">
                                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col-md-3">
                                                            <label class="d-flex align-items-center">
                                                                <input type="checkbox" name="permission[]"
                                                                    value="<?php echo e($permission->name); ?>"
                                                                    class="permission-checkbox <?php echo e($categoryName); ?>-checkbox <?php echo e($subCategoryName); ?>-checkbox mr-1"
                                                                    <?php echo e(in_array($permission->id, $assignPermissions) ? 'checked' : ''); ?>>
                                                                <span><?php echo e($permission->display_name); ?></span>
                                                            </label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    <a href="<?php echo e(route('roles.index')); ?>" class="btn btn-default">Discard</a>
                    <button class="btn btn-submit">Update</button>
                </div>
            </form>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            // Handle category checkbox change
            $('.category-checkbox').change(function() {
                var category = $(this).data('category');
                $('.' + category + '-checkbox').prop('checked', $(this).prop('checked'));
            });

            // Handle subcategory checkbox change
            $('.subcategory-checkbox').change(function() {
                var subcategory = $(this).data('subcategory');
                $('.' + subcategory + '-checkbox').prop('checked', $(this).prop('checked'));
            });

            // Handle individual permission checkbox change
            $('.permission-checkbox').change(function() {
                var category = $(this).closest('.col-md-4').find('.category-checkbox').data('category');
                var subcategory = $(this).closest('.col-md-12').find('.subcategory-checkbox').data('subcategory');

                // Update category checkbox based on permissions
                if ($('.' + category + '-checkbox:checked').length === $('.' + category + '-checkbox').length) {
                    $('.category-checkbox[data-category="' + category + '"]').prop('checked', true);
                } else {
                    $('.category-checkbox[data-category="' + category + '"]').prop('checked', false);
                }

                // Update subcategory checkbox based on permissions
                if (subcategory) {
                    if ($('.' + subcategory + '-checkbox:checked').length === $('.' + subcategory + '-checkbox').length) {
                        $('.subcategory-checkbox[data-subcategory="' + subcategory + '"]').prop('checked', true);
                    } else {
                        $('.subcategory-checkbox[data-subcategory="' + subcategory + '"]').prop('checked', false);
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EdueasyCollege/resources/views/role-permission/assign-pernission/create.blade.php ENDPATH**/ ?>